/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public final class ScopeStack {
    public final @Nullable ScopeStack parent;
    public final String scopeName;

    static @Nullable ScopeStack push(@Nullable ScopeStack path, List<String> scopeNames) {
        for (String name : scopeNames) {
            path = new ScopeStack(path, name);
        }
        return path;
    }

    public static ScopeStack from(String first) {
        return new ScopeStack(null, first);
    }

    public static @Nullable ScopeStack from(String ... segments) {
        ScopeStack result = null;
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            result = new ScopeStack(result, segment);
            ++n2;
        }
        return result;
    }

    ScopeStack(@Nullable ScopeStack parent, String scopeName) {
        this.parent = parent;
        this.scopeName = scopeName;
    }

    ScopeStack push(String scopeName) {
        return new ScopeStack(this, scopeName);
    }

    public List<String> getSegments() {
        @Nullable ScopeStack item = this;
        ArrayList<String> result = new ArrayList<String>();
        while (item != null) {
            result.add(item.scopeName);
            item = item.parent;
        }
        Collections.reverse(result);
        return result;
    }

    public String toString() {
        return String.join((CharSequence)" ", this.getSegments());
    }

    public boolean isExtending(ScopeStack other) {
        if (this == other) {
            return true;
        }
        ScopeStack parent = this.parent;
        if (parent == null) {
            return false;
        }
        return parent.isExtending(other);
    }

    List<String> getExtensionIfDefined(@Nullable ScopeStack base) {
        ArrayList<String> result = new ArrayList<String>();
        @Nullable ScopeStack item = this;
        while (item != null && item != base) {
            result.add(item.scopeName);
            item = item.parent;
        }
        if (item == base) {
            Collections.reverse(result);
            return result;
        }
        return Collections.emptyList();
    }
}

