/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swtchart.extensions.core.AbstractSeriesListUI;
import org.eclipse.swtchart.extensions.core.CustomSeriesLabelProvider;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.internal.support.CustomSeriesComparator;
import org.eclipse.swtchart.extensions.internal.support.CustomSeriesEditingSupport;

public class CustomSeriesListUI
extends AbstractSeriesListUI {
    private static final String[] TITLES = CustomSeriesLabelProvider.TITLES;
    private static final int[] BOUNDS = CustomSeriesLabelProvider.BOUNDS;
    private static final String COLUMN_DELIMITER = " ";
    private CustomSeriesLabelProvider labelProvider = new CustomSeriesLabelProvider();
    private IContentProvider contentProvider = ArrayContentProvider.getInstance();
    private CustomSeriesComparator comparator = new CustomSeriesComparator();
    private List<TableViewerColumn> columns = new ArrayList<TableViewerColumn>();
    private IPreferenceStore preferenceStore = ResourceSupport.getPreferenceStore();

    public CustomSeriesListUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void setTableSortable(boolean enable) {
        if (enable) {
            this.setComparator(this.comparator);
        } else {
            this.setComparator(null);
        }
    }

    private void createControl() {
        this.createColumns(TITLES, BOUNDS);
        this.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.setContentProvider(this.contentProvider);
        this.setComparator(null);
        this.setEditSupport();
        this.setColumnOrder(this.getTable());
    }

    private void createColumns(String[] titles, int[] bounds) {
        Table table = this.getTable();
        table.setRedraw(false);
        table.clearAll();
        while (table.getColumnCount() > 0) {
            table.getColumns()[0].dispose();
        }
        table.setRedraw(true);
        this.refresh();
        if (this.getLabelProvider() != null) {
            int i = 0;
            while (i < titles.length) {
                String title = titles[i];
                TableViewerColumn tableViewerColumn = this.createTableColumn(title, bounds[i]);
                TableColumn tableColumn = tableViewerColumn.getColumn();
                tableColumn.addSelectionListener((SelectionListener)this.createSelectionAdapter(i));
                this.columns.add(tableViewerColumn);
                ++i;
            }
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    private SelectionAdapter createSelectionAdapter(final int index) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomSeriesListUI.this.comparator.setColumn(index);
                int direction = CustomSeriesListUI.this.comparator.getDirection();
                CustomSeriesListUI.this.getTable().setSortDirection(direction);
                CustomSeriesListUI.this.refresh();
            }
        };
    }

    private TableViewerColumn createTableColumn(String title, int width) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)this, 0);
        TableColumn tableColumn = tableViewerColumn.getColumn();
        tableColumn.setText(title);
        tableColumn.setWidth(width);
        tableColumn.setResizable(true);
        tableColumn.setMoveable(true);
        tableColumn.addListener(10, new Listener(){

            public void handleEvent(Event event) {
                String columnOrder = CustomSeriesListUI.this.getColumnOrder(CustomSeriesListUI.this.getTable());
                if (CustomSeriesListUI.this.preferenceStore != null) {
                    CustomSeriesListUI.this.preferenceStore.setValue("customSeriesColumnOrder", columnOrder);
                    ResourceSupport.savePreferenceStore();
                }
            }
        });
        return tableViewerColumn;
    }

    private void setEditSupport() {
        int i = 0;
        while (i < this.columns.size()) {
            TableViewerColumn tableViewerColumn = this.columns.get(i);
            tableViewerColumn.setEditingSupport((EditingSupport)new CustomSeriesEditingSupport(this, i));
            ++i;
        }
    }

    private String getColumnOrder(Table table) {
        return this.convertColumnOrder(table.getColumnOrder());
    }

    private void setColumnOrder(Table table) {
        if (this.preferenceStore != null) {
            try {
                String columnOrder = this.preferenceStore.getString("customSeriesColumnOrder");
                if (!columnOrder.isEmpty()) {
                    int[] columns = this.convertColumnOrder(columnOrder);
                    table.setColumnOrder(columns);
                }
            }
            catch (IllegalArgumentException | SWTException throwable) {
                // empty catch block
            }
        }
    }

    private int[] convertColumnOrder(String columnOrder) {
        String[] values = columnOrder.split(COLUMN_DELIMITER);
        int size = values.length;
        int[] columns = new int[size];
        int i = 0;
        while (i < size) {
            try {
                columns[i] = Integer.parseInt(values[i]);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return columns;
    }

    private String convertColumnOrder(int[] columnOrder) {
        StringBuilder builder = new StringBuilder();
        int[] nArray = columnOrder;
        int n = columnOrder.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            builder.append(i);
            builder.append(COLUMN_DELIMITER);
            ++n2;
        }
        return builder.toString().trim();
    }
}

