/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.launchbar.ui.ILaunchBarUIManager;
import org.eclipse.launchbar.ui.internal.LaunchBarUIManager;
import org.eclipse.launchbar.ui.internal.target.LaunchTargetUIManager;
import org.eclipse.launchbar.ui.target.ILaunchTargetUIManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.launchbar.ui";
    public static final String IMG_LOCAL_TARGET = "localTarget";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ImageRegistry imageRegistry = this.getImageRegistry();
        imageRegistry.put(IMG_LOCAL_TARGET, Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/localTarget.png"));
        context.registerService(ILaunchTargetUIManager.class, (Object)new LaunchTargetUIManager(), null);
        context.registerService(ILaunchBarUIManager.class, (Object)new LaunchBarUIManager(), null);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public Image getImage(String id) {
        ImageDescriptor des;
        Image im = this.getImageRegistry().get(id);
        if (im == null && (des = Activator.getImageDescriptor(id)) != null) {
            im = des.createImage();
            this.getImageRegistry().put(id, im);
        }
        return im;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void log(Exception e) {
        if (e instanceof CoreException) {
            Activator.log(((CoreException)((Object)e)).getStatus());
        }
        plugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getLocalizedMessage(), (Throwable)e));
    }

    public static <T> T getService(Class<T> cls) {
        BundleContext context = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(cls);
        return (T)(ref != null ? context.getService(ref) : null);
    }
}

