/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.PathVariableEditDialog;

public class RelativePathVariableGroup {
    private Button variableCheckbox = null;
    private Combo variableCombo = null;
    private Shell shell;
    private final IModel content;
    private String label;

    public RelativePathVariableGroup(IModel content) {
        this.content = content;
    }

    public RelativePathVariableGroup(IModel content, String label) {
        this.content = content;
        this.label = label;
    }

    public Control createContents(Composite variableGroup) {
        this.shell = variableGroup.getShell();
        this.variableCheckbox = new Button(variableGroup, 32);
        this.variableCheckbox.setText(this.label != null ? this.label : IDEWorkbenchMessages.ImportTypeDialog_importElementsAs);
        GridData gridData = new GridData(32);
        this.variableCheckbox.setFont(variableGroup.getFont());
        this.variableCheckbox.setLayoutData((Object)gridData);
        this.variableCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.selectRelativeCombo();
            }

            public void widgetSelected(SelectionEvent e) {
                this.selectRelativeCombo();
            }

            private void selectRelativeCombo() {
                if (RelativePathVariableGroup.this.variableCheckbox.getSelection()) {
                    RelativePathVariableGroup.this.variableCombo.setEnabled(true);
                    RelativePathVariableGroup.this.selectVariable(RelativePathVariableGroup.this.variableCombo.getItem(RelativePathVariableGroup.this.variableCombo.getSelectionIndex()));
                    RelativePathVariableGroup.this.variableCheckbox.setToolTipText(IDEWorkbenchMessages.ImportTypeDialog_importElementsAsTooltipSet);
                } else {
                    RelativePathVariableGroup.this.variableCombo.setEnabled(false);
                    RelativePathVariableGroup.this.content.setVariable(null);
                    RelativePathVariableGroup.this.variableCheckbox.setToolTipText(IDEWorkbenchMessages.ImportTypeDialog_importElementsAsTooltip);
                }
                RelativePathVariableGroup.this.setupVariableCheckboxToolTip();
            }
        });
        this.variableCombo = new Combo(variableGroup, 12);
        gridData = new GridData(32);
        this.variableCombo.setLayoutData((Object)gridData);
        this.variableCombo.setFont(variableGroup.getFont());
        this.variableCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (RelativePathVariableGroup.this.variableCombo.getSelectionIndex() == RelativePathVariableGroup.this.variableCombo.getItemCount() - 1) {
                    RelativePathVariableGroup.this.editVariables();
                } else {
                    RelativePathVariableGroup.this.selectVariable(RelativePathVariableGroup.this.variableCombo.getItem(RelativePathVariableGroup.this.variableCombo.getSelectionIndex()));
                }
            }

            public void widgetSelected(SelectionEvent e) {
                if (RelativePathVariableGroup.this.variableCombo.getSelectionIndex() == RelativePathVariableGroup.this.variableCombo.getItemCount() - 1) {
                    RelativePathVariableGroup.this.editVariables();
                } else {
                    RelativePathVariableGroup.this.selectVariable(RelativePathVariableGroup.this.variableCombo.getItem(RelativePathVariableGroup.this.variableCombo.getSelectionIndex()));
                }
            }
        });
        this.setupVariableContent();
        this.selectVariable("PROJECT_LOC");
        return variableGroup;
    }

    public void setupVariableContent() {
        IPathVariableManager pathVariableManager = this.content.getResource() != null ? this.content.getResource().getPathVariableManager() : ResourcesPlugin.getWorkspace().getPathVariableManager();
        ArrayList<String> items = new ArrayList<String>();
        String[] stringArray = pathVariableManager.getPathVariableNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String variableName = stringArray[n2];
            if (!variableName.equals("PARENT")) {
                items.add(variableName);
            }
            ++n2;
        }
        items.add(IDEWorkbenchMessages.ImportTypeDialog_editVariables);
        this.variableCombo.setItems(items.toArray(new String[0]));
    }

    private void setupVariableCheckboxToolTip() {
        if (this.variableCheckbox != null) {
            if (this.variableCheckbox.getSelection()) {
                this.variableCheckbox.setToolTipText(IDEWorkbenchMessages.ImportTypeDialog_importElementsAsTooltipSet);
            } else {
                this.variableCheckbox.setToolTipText(IDEWorkbenchMessages.ImportTypeDialog_importElementsAsTooltip);
            }
        }
    }

    private void editVariables() {
        String[] variableNames;
        String selectedItem = this.content.getVariable();
        PathVariableEditDialog dialog = new PathVariableEditDialog(this.shell);
        dialog.setResource(this.content.getResource());
        if (dialog.open() == 0 && (variableNames = (String[])dialog.getResult()) != null && variableNames.length >= 1) {
            selectedItem = variableNames[0];
        }
        this.setupVariableContent();
        if (selectedItem != null) {
            this.selectVariable(selectedItem);
        }
    }

    public void selectVariable(String var) {
        String[] items = this.variableCombo.getItems();
        int i = 0;
        while (i < items.length) {
            if (var.equals(items[i])) {
                this.variableCombo.select(i);
                this.content.setVariable(items[i]);
                return;
            }
            ++i;
        }
        this.variableCombo.select(0);
        this.content.setVariable(items[0]);
    }

    public void setEnabled(boolean b) {
        this.variableCheckbox.setEnabled(b);
        this.variableCombo.setEnabled(this.variableCheckbox.getSelection() && this.variableCheckbox.isEnabled());
        this.setupVariableCheckboxToolTip();
    }

    public void setSelection(boolean b) {
        this.variableCheckbox.setSelection(b);
        this.setupVariableCheckboxToolTip();
        this.variableCombo.setEnabled(this.variableCheckbox.getSelection() && this.variableCheckbox.isEnabled());
    }

    public static String getPreferredVariable(IPath[] paths, IContainer target) {
        IPath commonRoot = null;
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            if (path != null) {
                if (commonRoot == null) {
                    commonRoot = path;
                } else {
                    int count = commonRoot.matchingFirstSegments(path);
                    int remainingSegments = commonRoot.segmentCount() - count;
                    if (remainingSegments <= 0) {
                        return null;
                    }
                    commonRoot = commonRoot.removeLastSegments(remainingSegments);
                }
            }
            ++n2;
        }
        String mostAppropriate = null;
        String mostAppropriateToParent = null;
        int mostAppropriateCount = Integer.MAX_VALUE;
        int mostAppropriateCountToParent = Integer.MAX_VALUE;
        IPathVariableManager pathVariableManager = target.getPathVariableManager();
        String[] stringArray = pathVariableManager.getPathVariableNames();
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            IPath path;
            URI rawValue;
            URI value;
            String variableName = stringArray[n4];
            if (RelativePathVariableGroup.isPreferred(variableName) && (value = pathVariableManager.resolveURI(rawValue = pathVariableManager.getURIValue(variableName))) != null && (path = URIUtil.toPath((URI)value)) != null) {
                int difference = path.matchingFirstSegments(commonRoot);
                if (difference > 0) {
                    if (difference < mostAppropriateCount) {
                        mostAppropriateCount = difference;
                        mostAppropriate = variableName;
                    }
                } else {
                    difference = commonRoot.matchingFirstSegments(path);
                    if (difference > 0 && difference < mostAppropriateCountToParent) {
                        mostAppropriateCountToParent = difference;
                        mostAppropriateToParent = variableName;
                    }
                }
            }
            ++n4;
        }
        if (mostAppropriate == null) {
            if (mostAppropriateToParent == null) {
                return "PROJECT_LOC";
            }
            return mostAppropriateToParent;
        }
        return mostAppropriate;
    }

    private static boolean isPreferred(String variableName) {
        return !variableName.equals("WORKSPACE_LOC") && !variableName.equals("PARENT_LOC") && !variableName.equals("PARENT");
    }

    public static String getPreferredVariable(IResource[] sources, IContainer target) {
        IPath[] paths = new IPath[sources.length];
        int i = 0;
        while (i < sources.length) {
            paths[i] = sources[i].getLocation();
            ++i;
        }
        return RelativePathVariableGroup.getPreferredVariable(paths, target);
    }

    public static String getPreferredVariable(String[] names, IContainer target) {
        IPath[] paths = new IPath[names.length];
        int i = 0;
        while (i < names.length) {
            paths[i] = IPath.fromOSString((String)names[i]);
            ++i;
        }
        return RelativePathVariableGroup.getPreferredVariable(paths, target);
    }

    public boolean getSelection() {
        return this.variableCheckbox.getSelection();
    }

    public static interface IModel {
        public IResource getResource();

        public void setVariable(String var1);

        public String getVariable();
    }
}

