/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.scheduler;

import java.util.Objects;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdateMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdatePlugin;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

class UpdatesPopup
extends PopupDialog {
    private static final int POPUP_OFFSET = 20;
    protected Composite dialogArea;
    private final MouseListener clickListener;
    private final String message;

    public UpdatesPopup(Shell parentShell, String message) {
        super(parentShell, 16, false, true, true, false, false, AutomaticUpdateMessages.AutomaticUpdatesPopup_UpdatesAvailableTitle, null);
        this.message = Objects.requireNonNull(message);
        this.clickListener = MouseListener.mouseDownAdapter(e -> AutomaticUpdatePlugin.getDefault().getAutomaticUpdater().launchUpdate());
    }

    protected Composite createDialogArea(Composite parent) {
        this.dialogArea = new Composite(parent, 0);
        this.dialogArea.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.dialogArea.setLayout((Layout)layout);
        this.dialogArea.addMouseListener(this.clickListener);
        Label infoLabel = new Label(this.dialogArea, 0);
        infoLabel.setText(this.message);
        infoLabel.setLayoutData((Object)new GridData(1808));
        infoLabel.addMouseListener(this.clickListener);
        return this.dialogArea;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(AutomaticUpdateMessages.AutomaticUpdatesPopup_UpdatesAvailableTitle);
    }

    protected Point getInitialLocation(Point initialSize) {
        Point parentLocation;
        Point parentSize;
        Shell parent = this.getParentShell();
        if (parent != null) {
            parentSize = parent.getSize();
            parentLocation = parent.getLocation();
        } else {
            Rectangle bounds = this.getShell().getDisplay().getBounds();
            parentSize = new Point(bounds.width, bounds.height);
            parentLocation = new Point(0, 0);
        }
        return new Point(parentSize.x - initialSize.x + parentLocation.x - 20, parentSize.y - initialSize.y + parentLocation.y - 20);
    }

    protected Control createTitleMenuArea(Composite parent) {
        Composite titleComposite = (Composite)super.createTitleMenuArea(parent);
        titleComposite.addMouseListener(this.clickListener);
        ToolBar toolBar = new ToolBar(titleComposite, 0x800000);
        ToolItem closeButton = new ToolItem(toolBar, 8, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)toolBar);
        closeButton.setImage(AutomaticUpdatePlugin.getDefault().getImageRegistry().get("tool/close.svg"));
        closeButton.setHotImage(AutomaticUpdatePlugin.getDefault().getImageRegistry().get("tool/close_hot.svg"));
        closeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.close();
        }));
        toolBar.addMouseListener(MouseListener.mouseDownAdapter(e -> {
            boolean bl = this.close();
        }));
        return titleComposite;
    }

    protected Control createTitleControl(Composite parent) {
        Control control = super.createTitleControl(parent);
        Object data = control.getLayoutData();
        if (data instanceof GridData) {
            ((GridData)data).horizontalSpan = 1;
        }
        return control;
    }
}

