/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.Optional;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVariableReadWriteFlags;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotations;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkage;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPVariable
extends PDOMCPPBinding
implements ICPPVariable {
    private static final int TYPE_OFFSET = 32;
    private static final int VALUE_OFFSET = 38;
    private static final int ANNOTATIONS = 43;
    protected static final int RECORD_SIZE = 44;

    public PDOMCPPVariable(PDOMCPPLinkage linkage, PDOMNode parent, ICPPVariable variable, boolean setTypeAndValue) throws CoreException {
        super(linkage, parent, variable.getNameCharArray());
        Database db = this.getDB();
        db.putByte(this.record + 43L, PDOMCPPAnnotations.encodeVariableAnnotations(variable));
        if (setTypeAndValue) {
            this.setType(parent.getLinkage(), variable.getType());
            PDOMCPPLinkage pDOMCPPLinkage = linkage;
            pDOMCPPLinkage.getClass();
            pDOMCPPLinkage.new PDOMCPPLinkage.ConfigureVariable(variable, this);
        }
    }

    public void initData(IValue initialValue) {
        try {
            this.setValue(initialValue);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    protected void setValue(IValue value) throws CoreException {
        ((PDOMLinkage)this.getLinkage()).storeValue(this.record + 38L, value);
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof IVariable) {
            Database db = this.getDB();
            ICPPVariable var = (ICPPVariable)newBinding;
            IType newType = var.getType();
            this.setType(linkage, newType);
            this.setValue(var.getInitialValue());
            db.putByte(this.record + 43L, PDOMCPPAnnotations.encodeVariableAnnotations(var));
        }
    }

    protected void setType(PDOMLinkage linkage, IType newType) throws CoreException {
        linkage.storeType(this.record + 32L, newType);
    }

    public PDOMCPPVariable(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    @Override
    protected int getRecordSize() {
        return 44;
    }

    @Override
    public int getNodeType() {
        return 6;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public IType getType() {
        try {
            return ((PDOMLinkage)this.getLinkage()).loadType(this.record + 32L);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    @Override
    public IValue getInitialValue() {
        try {
            return ((PDOMLinkage)this.getLinkage()).loadValue(this.record + 38L);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return IntegralValue.UNKNOWN;
        }
    }

    @Override
    public boolean isAuto() {
        byte annotation = this.getAnnotations();
        return !PDOMCPPAnnotations.isExtern(annotation) && !PDOMCPPAnnotations.isStatic(annotation) && this.getOwner() instanceof ICPPFunction;
    }

    @Override
    public boolean isExtern() {
        return PDOMCPPAnnotations.isExtern(this.getAnnotations());
    }

    @Override
    public boolean isExternC() {
        return PDOMCPPAnnotations.isExternC(this.getAnnotations());
    }

    @Override
    public boolean isRegister() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return PDOMCPPAnnotations.isStatic(this.getAnnotations());
    }

    @Override
    public boolean isConstexpr() {
        return PDOMCPPAnnotations.isConstexpr(this.getAnnotations());
    }

    protected final byte getAnnotations() {
        return this.getByte(this.record + 43L);
    }

    @Override
    public int getAdditionalNameFlags(int standardFlags, IASTName name) {
        if ((standardFlags & 3) == 3) {
            Optional<Integer> res = CPPVariableReadWriteFlags.getReadWriteFlags(name);
            if (!res.isPresent()) {
                return 96;
            }
            return res.get();
        }
        return 0;
    }
}

