/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.memory;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.memory.UstMemoryAnalysisModule;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.lttng2.ust.core.trace.layout.ILttngUstEventLayout;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class UstMemoryStateProvider
extends AbstractTmfStateProvider {
    private static final int VERSION = 2;
    private static final Long MINUS_ONE = -1L;
    private static final Long ZERO = 0L;
    private static final int MALLOC_INDEX = 1;
    private static final int FREE_INDEX = 2;
    private static final int CALLOC_INDEX = 3;
    private static final int REALLOC_INDEX = 4;
    private static final int MEMALIGN_INDEX = 5;
    private static final int POSIX_MEMALIGN_INDEX = 6;
    private final Map<Long, MemoryAllocation> fMemory = new HashMap<Long, MemoryAllocation>();
    private final @NonNull ILttngUstEventLayout fLayout;
    private final @NonNull Map<String, Integer> fEventNames;
    private final @Nullable UstMemoryAnalysisModule fAnalysis;

    public UstMemoryStateProvider(@NonNull ITmfTrace trace, @Nullable UstMemoryAnalysisModule baseAnalysis) {
        super(trace, "Ust:Memory");
        this.fLayout = !(trace instanceof LttngUstTrace) ? ILttngUstEventLayout.DEFAULT_LAYOUT : ((LttngUstTrace)trace).getEventLayout();
        this.fEventNames = UstMemoryStateProvider.buildEventNames(this.fLayout);
        this.fAnalysis = baseAnalysis;
    }

    private static @NonNull Map<String, Integer> buildEventNames(ILttngUstEventLayout layout) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)layout.eventLibcMalloc(), (Object)1);
        builder.put((Object)layout.eventLibcFree(), (Object)2);
        builder.put((Object)layout.eventLibcCalloc(), (Object)3);
        builder.put((Object)layout.eventLibcRealloc(), (Object)4);
        builder.put((Object)layout.eventLibcMemalign(), (Object)5);
        builder.put((Object)layout.eventLibcPosixMemalign(), (Object)6);
        return builder.build();
    }

    protected void eventHandle(ITmfEvent event) {
        String name = event.getName();
        Integer index = this.fEventNames.get(name);
        int intIndex = index == null ? -1 : index;
        switch (intIndex) {
            case 1: {
                Long ptr = (Long)event.getContent().getField(new String[]{this.fLayout.fieldPtr()}).getValue();
                if (ZERO.equals(ptr)) {
                    return;
                }
                Long size = (Long)event.getContent().getField(new String[]{this.fLayout.fieldSize()}).getValue();
                this.setMem(event, ptr, size);
                break;
            }
            case 2: {
                Long ptr = (Long)event.getContent().getField(new String[]{this.fLayout.fieldPtr()}).getValue();
                if (ZERO.equals(ptr)) {
                    return;
                }
                this.setMem(event, ptr, ZERO);
                break;
            }
            case 3: {
                Long ptr = (Long)event.getContent().getField(new String[]{this.fLayout.fieldPtr()}).getValue();
                if (ZERO.equals(ptr)) {
                    return;
                }
                Long nmemb = (Long)event.getContent().getField(new String[]{this.fLayout.fieldNmemb()}).getValue();
                Long size = (Long)event.getContent().getField(new String[]{this.fLayout.fieldSize()}).getValue();
                this.setMem(event, ptr, size * nmemb);
                break;
            }
            case 4: {
                Long ptr = (Long)event.getContent().getField(new String[]{this.fLayout.fieldPtr()}).getValue();
                if (ZERO.equals(ptr)) {
                    return;
                }
                Long inPtr = (Long)event.getContent().getField(new String[]{this.fLayout.fieldInPtr()}).getValue();
                Long size = (Long)event.getContent().getField(new String[]{this.fLayout.fieldSize()}).getValue();
                this.setMem(event, inPtr, ZERO);
                this.setMem(event, ptr, size);
                break;
            }
            case 5: {
                Long ptr = (Long)event.getContent().getField(new String[]{this.fLayout.fieldPtr()}).getValue();
                if (ZERO.equals(ptr)) {
                    return;
                }
                Long size = (Long)event.getContent().getField(new String[]{this.fLayout.fieldSize()}).getValue();
                this.setMem(event, ptr, size);
                break;
            }
            case 6: {
                Long ptr = (Long)event.getContent().getField(new String[]{this.fLayout.fieldOutPtr()}).getValue();
                if (ZERO.equals(ptr)) {
                    return;
                }
                Long size = (Long)event.getContent().getField(new String[]{this.fLayout.fieldSize()}).getValue();
                this.setMem(event, ptr, size);
                break;
            }
        }
    }

    public ITmfStateProvider getNewInstance() {
        return new UstMemoryStateProvider((ITmfTrace)this.getTrace(), this.fAnalysis);
    }

    public LttngUstTrace getTrace() {
        return (LttngUstTrace)super.getTrace();
    }

    public int getVersion() {
        return 2;
    }

    private static Long getVtid(ITmfEvent event) {
        Integer tid = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxTidAspect.class, (ITmfEvent)event);
        if (tid == null) {
            return MINUS_ONE;
        }
        return tid.longValue();
    }

    private @Nullable String getProcname(ITmfEvent event) {
        ITmfEventField field = event.getContent().getField(new String[]{this.fLayout.contextProcname()});
        if (field == null) {
            return null;
        }
        return (String)field.getValue();
    }

    private void setMem(ITmfEvent event, Long ptr, Long size) {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
        long ts = event.getTimestamp().toNanos();
        Long tid = UstMemoryStateProvider.getVtid(event);
        Long memoryDiff = size;
        if (ZERO.equals(size)) {
            MemoryAllocation memAlloc = this.fMemory.remove(ptr);
            if (memAlloc == null) {
                return;
            }
            memoryDiff = -memAlloc.getSize().longValue();
        } else {
            this.fMemory.put(ptr, new MemoryAllocation(ts, tid, size));
        }
        try {
            int tidQuark = ss.getQuarkAbsoluteAndAdd(new String[]{tid.toString()});
            int tidMemQuark = ss.getQuarkRelativeAndAdd(tidQuark, new String[]{"Memory"});
            ITmfStateValue prevMem = ss.queryOngoingState(tidMemQuark);
            if (prevMem.isNull()) {
                String procName = this.getProcname(event);
                if (tid.equals(MINUS_ONE)) {
                    procName = "Others";
                }
                if (procName != null) {
                    int procNameQuark = ss.getQuarkRelativeAndAdd(tidQuark, new String[]{"Procname"});
                    ss.modifyAttribute(ts, (Object)procName, procNameQuark);
                }
                prevMem = TmfStateValue.newValueLong((long)0L);
            }
            long prevMemValue = prevMem.unboxLong();
            ss.modifyAttribute(ts, (Object)(prevMemValue += memoryDiff.longValue()), tidMemQuark);
        }
        catch (StateValueTypeException | TimeRangeException e) {
            throw new IllegalStateException(e);
        }
    }

    public void done() {
        UstMemoryAnalysisModule analysis = this.fAnalysis;
        if (analysis != null) {
            analysis.setPotentialLeaks(this.fMemory);
        }
    }

    public static class MemoryAllocation {
        private final long fTs;
        private final Long fTid;
        private final Long fSize;

        public MemoryAllocation(long ts, Long tid, Long size) {
            this.fTs = ts;
            this.fTid = tid;
            this.fSize = size;
        }

        public long getTs() {
            return this.fTs;
        }

        public Long getTid() {
            return this.fTid;
        }

        public Long getSize() {
            return this.fSize;
        }
    }
}

