/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.context.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.wikitext.context.ui.ActiveFoldingEditorTracker;
import org.eclipse.mylyn.internal.wikitext.context.ui.WikiTextUserInteractionMonitor;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class WikiTextContextUiPlugin
extends AbstractUIPlugin {
    public static final String PREF_ACTIVE_FOLDING_ENABLED = "org.eclipse.mylyn.context.ui.editor.folding.enabled";
    private static WikiTextContextUiPlugin plugin;
    private WikiTextUserInteractionMonitor userInteractionMonitor;
    private ActiveFoldingEditorTracker activeFoldingEditorTracker;

    public WikiTextContextUiPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.userInteractionMonitor != null) {
            MonitorUi.getSelectionMonitors().remove((Object)this.userInteractionMonitor);
            this.userInteractionMonitor = null;
        }
        if (this.activeFoldingEditorTracker != null) {
            this.activeFoldingEditorTracker.dispose(PlatformUI.getWorkbench());
            this.activeFoldingEditorTracker = null;
        }
        plugin = null;
        super.stop(context);
    }

    public static WikiTextContextUiPlugin getDefault() {
        return plugin;
    }

    public void log(Throwable ce) {
        if (ce instanceof CoreException) {
            this.getLog().log(((CoreException)ce).getStatus());
        } else {
            this.log(4, ce.getMessage(), ce);
        }
    }

    public void log(int severity, String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        ILog log = this.getLog();
        IStatus status = null;
        if (exception instanceof CoreException) {
            status = ((CoreException)exception).getStatus();
        }
        if (status == null) {
            status = new Status(severity, this.getPluginId(), severity, message, exception);
        }
        log.log(status);
    }

    public String getPluginId() {
        return this.getBundle().getSymbolicName();
    }

    public IStatus createStatus(int statusCode, Throwable exception) {
        return this.createStatus(null, statusCode, exception);
    }

    public IStatus createStatus(String message, int statusCode, Throwable exception) {
        if (message == null && exception != null) {
            message = exception.getClass().getName() + ": " + exception.getMessage();
        }
        Status status = new Status(statusCode, this.getPluginId(), statusCode, (String)message, exception);
        return status;
    }

    void contextUiStartup() {
        this.userInteractionMonitor = new WikiTextUserInteractionMonitor();
        MonitorUi.getSelectionMonitors().add(this.userInteractionMonitor);
        this.activeFoldingEditorTracker = new ActiveFoldingEditorTracker(PlatformUI.getWorkbench());
    }
}

