/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.ui.internal.genericeditor.ContentTypeSpecializationComparator;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;

public class IconsRegistry {
    private static final String EXTENSION_POINT_ID = "org.eclipse.ui.genericeditor.icons";
    private final Map<IContentType, ImageDescriptor> extensions = new LinkedHashMap<IContentType, ImageDescriptor>();
    private boolean outOfSync = true;

    public IconsRegistry() {
        Platform.getExtensionRegistry().addRegistryChangeListener(event -> {
            boolean bl = this.outOfSync = true;
        }, EXTENSION_POINT_ID);
    }

    public ImageDescriptor getImageDescriptor(IContentType[] contentTypes) {
        if (this.outOfSync) {
            this.sync();
        }
        return Arrays.stream(contentTypes).sorted(Collections.reverseOrder(Comparator.comparingInt(ContentTypeSpecializationComparator::depth))).map(this.extensions::get).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private void sync() {
        HashSet<IContentType> toRemoveContentTypes = new HashSet<IContentType>(this.extensions.keySet());
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            try {
                IContentType contentType;
                String contentTypeId = extension.getAttribute("contentType");
                if (contentTypeId != null && !contentTypeId.isEmpty() && (contentType = Platform.getContentTypeManager().getContentType(contentTypeId)) != null) {
                    String icon;
                    toRemoveContentTypes.remove(contentType);
                    if (!this.extensions.containsKey(contentType) && (icon = extension.getAttribute("icon")) != null && !icon.isEmpty()) {
                        ResourceLocator.imageDescriptorFromBundle((String)extension.getNamespaceIdentifier(), (String)icon).ifPresent(imageDescriptor -> {
                            ImageDescriptor imageDescriptor2 = this.extensions.put(contentType, (ImageDescriptor)imageDescriptor);
                        });
                    }
                }
            }
            catch (Exception ex) {
                GenericEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.genericeditor", ex.getMessage(), (Throwable)ex));
            }
            ++n2;
        }
        for (IContentType toRemove : toRemoveContentTypes) {
            this.extensions.remove(toRemove);
        }
        this.outOfSync = false;
    }
}

