/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.internal.parser.html;

import java.util.List;
import org.eclipse.mylyn.wikitext.internal.parser.html.DocumentProcessor;
import org.eclipse.mylyn.wikitext.internal.parser.html.Html;
import org.eclipse.mylyn.wikitext.util.Strings;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

class RemoveEmptySpansProcessor
extends DocumentProcessor {
    RemoveEmptySpansProcessor() {
    }

    @Override
    public void process(Document document) {
        Element body = document.body();
        boolean modifiedOne = false;
        do {
            modifiedOne = false;
            for (Element element : body.getAllElements()) {
                if (Html.isSpanElement(element)) {
                    Node node;
                    List childNodes = element.childNodes();
                    if (childNodes.isEmpty() && !this.isHyperlinkWithTarget(element)) {
                        element.remove();
                        modifiedOne = true;
                    } else if (childNodes.size() == 1 && (node = (Node)childNodes.get(0)) instanceof TextNode) {
                        TextNode textNode = (TextNode)node;
                        String text = textNode.text();
                        if (text.trim().length() == 0) {
                            textNode.remove();
                            element.before((Node)textNode);
                            element.remove();
                            modifiedOne = true;
                        }
                        RemoveEmptySpansProcessor.normalizeTextNodes(textNode.parent());
                    }
                }
                Element parent = element.parent();
                if (!element.tagName().equalsIgnoreCase("br") || !Html.isSpanElement(parent)) continue;
                List childNodes = parent.childNodes();
                if (childNodes.get(0) == element) {
                    element.remove();
                    parent.before((Node)element);
                    modifiedOne = true;
                    continue;
                }
                if (childNodes.get(childNodes.size() - 1) != element) continue;
                element.remove();
                parent.after((Node)element);
                modifiedOne = true;
            }
        } while (modifiedOne);
    }

    private boolean isHyperlinkWithTarget(Element element) {
        return element.tagName().equalsIgnoreCase("a") && !Strings.isNullOrEmpty(element.attr("href"));
    }
}

