/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.internal.util;

public class XmlUtil {
    public static String getEscapedAttribute(String s) {
        StringBuilder result = new StringBuilder(s.length() + 10);
        int i = 0;
        while (i < s.length()) {
            XmlUtil.appendEscapedChar(result, s.charAt(i), true);
            ++i;
        }
        return result.toString();
    }

    public static String getEscapedContent(String s) {
        StringBuilder result = new StringBuilder(s.length() + 10);
        int i = 0;
        while (i < s.length()) {
            XmlUtil.appendEscapedChar(result, s.charAt(i), false);
            ++i;
        }
        return result.toString();
    }

    private static void appendEscapedChar(StringBuilder buffer, char c, boolean forAttribute) {
        String replacement = XmlUtil.getReplacement(c, forAttribute);
        if (replacement != null) {
            buffer.append('&');
            buffer.append(replacement);
            buffer.append(';');
        } else if (c >= '\u0000' && c <= '\u001f' && c != '\t' && c != '\n' && c != '\r') {
            buffer.append("\ufffd");
        } else {
            buffer.append(c);
        }
    }

    private static String getReplacement(char c, boolean forAttribute) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '&': {
                return "amp";
            }
        }
        if (forAttribute) {
            switch (c) {
                case '\"': {
                    return "quot";
                }
                case '\'': {
                    return "apos";
                }
                case '\t': {
                    return "#x9";
                }
                case '\n': {
                    return "#xA";
                }
                case '\r': {
                    return "#xD";
                }
            }
        }
        return null;
    }
}

