/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.builder;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.builder.HtmlEntities;

public class EntityReferences {
    private static final Pattern NUMERIC_ENTITY_PATTERN = Pattern.compile("#(?:(?:x([0-9A-Fa-f]+))|([0-9]+))");
    private static final EntityReferences instance = new EntityReferences();

    public static EntityReferences instance() {
        return instance;
    }

    public String equivalentString(String entityReference) {
        Matcher matcher;
        Objects.requireNonNull(entityReference, "Must provide an entityReference");
        String entity = entityReference;
        if (entityReference.startsWith("&") && entityReference.endsWith(";")) {
            entity = entityReference.substring(1, entityReference.length() - 1);
        }
        if ((matcher = NUMERIC_ENTITY_PATTERN.matcher(entity)).matches()) {
            return this.equivalentString(matcher);
        }
        return HtmlEntities.instance().nameToStringEquivalent(entity);
    }

    private String equivalentString(Matcher matcher) {
        String numberPart = matcher.group(1);
        try {
            if (numberPart != null) {
                return String.valueOf((char)Integer.parseInt(numberPart, 16));
            }
            numberPart = matcher.group(2);
            return String.valueOf((char)Integer.parseInt(numberPart));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private EntityReferences() {
    }
}

