/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.archetype;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.core.ui.internal.archetype.ArchetypeCatalogFactory;
import org.eclipse.m2e.core.ui.internal.archetype.ArchetypePlugin;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionReader {
    private static final Logger log = LoggerFactory.getLogger(ExtensionReader.class);
    public static final String EXTENSION_ARCHETYPES = "org.eclipse.m2e.core.archetypeCatalogs";
    public static final String EXTENSION_PROJECT_CHANGED_EVENT_LISTENERS = "org.eclipse.m2e.core.mavenProjectChangedListeners";
    public static final String EXTENSION_INCREMENTAL_BUILD_FRAMEWORKS = "org.eclipse.m2e.core.incrementalBuildFrameworks";
    private static final String ELEMENT_LOCAL_ARCHETYPE = "local";
    private static final String ELEMENT_REMOTE_ARCHETYPE = "remote";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_URL = "url";
    private static final String ATTR_DESCRIPTION = "description";

    public static List<ArchetypeCatalogFactory> readArchetypeExtensions(ArchetypePlugin archetypePlugin) {
        ArrayList<ArchetypeCatalogFactory> archetypeCatalogs = new ArrayList<ArchetypeCatalogFactory>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint archetypesExtensionPoint = registry.getExtensionPoint(EXTENSION_ARCHETYPES);
        if (archetypesExtensionPoint != null) {
            IExtension[] archetypesExtensions;
            IExtension[] iExtensionArray = archetypesExtensions = archetypesExtensionPoint.getExtensions();
            int n = archetypesExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                IContributor contributor = extension.getContributor();
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    ArchetypeCatalogFactory factory = ExtensionReader.readArchetypeCatalogs(element, contributor, archetypePlugin);
                    archetypeCatalogs.add(factory);
                    ++n4;
                }
                ++n2;
            }
        }
        return archetypeCatalogs;
    }

    private static ArchetypeCatalogFactory readArchetypeCatalogs(IConfigurationElement element, IContributor contributor, ArchetypePlugin archetypePlugin) {
        String url;
        if (ELEMENT_LOCAL_ARCHETYPE.equals(element.getName())) {
            String name = element.getAttribute(ATTR_NAME);
            if (name != null) {
                Bundle[] bundles = Platform.getBundles((String)contributor.getName(), null);
                URL catalogUrl = null;
                Bundle[] bundleArray = bundles;
                int n = bundles.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle bundle = bundleArray[n2];
                    catalogUrl = bundle.getEntry(name);
                    if (catalogUrl != null) {
                        String description = element.getAttribute(ATTR_DESCRIPTION);
                        String url2 = catalogUrl.toString();
                        return archetypePlugin.newLocalCatalogFactory(url2, description, false, true);
                    }
                    ++n2;
                }
                log.error("Unable to find Archetype catalog " + name + " in " + contributor.getName());
            }
        } else if (ELEMENT_REMOTE_ARCHETYPE.equals(element.getName()) && (url = element.getAttribute(ATTR_URL)) != null) {
            String description = element.getAttribute(ATTR_DESCRIPTION);
            return archetypePlugin.newRemoteCatalogFactory(url, description, false, true);
        }
        return null;
    }
}

