/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.dialogs.AbstractMavenDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProjectSelectionDialog
extends AbstractMavenDialog {
    private static final Logger log = LoggerFactory.getLogger(MavenProjectSelectionDialog.class);
    protected static final String DIALOG_SETTINGS = MavenProjectSelectionDialog.class.getName();
    protected static final long SEARCH_DELAY = 500L;
    private FilteredTree filteredTree;
    private boolean useCheckboxTree;

    public MavenProjectSelectionDialog(Shell parent, boolean useCheckboxTree) {
        this(parent);
        this.useCheckboxTree = useCheckboxTree;
    }

    public MavenProjectSelectionDialog(Shell parent) {
        super(parent, DIALOG_SETTINGS);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(Messages.projectSelectionDialogTitle);
    }

    protected void computeResult() {
        if (this.useCheckboxTree) {
            ArrayList<Object> result = new ArrayList<Object>();
            this.collectCheckedItems(this.getViewer().getTree().getItems(), result);
            this.setResult(result);
        } else {
            this.setResult(((IStructuredSelection)this.getViewer().getSelection()).toList());
        }
    }

    private void collectCheckedItems(TreeItem[] items, List<Object> list) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object data;
            TreeItem item = treeItemArray[n2];
            if (item.getChecked() && (data = item.getData()) != null) {
                list.add(data);
            }
            this.collectCheckedItems(item.getItems(), list);
            ++n2;
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.readSettings();
        Composite composite = (Composite)super.createDialogArea(parent);
        this.filteredTree = new FilteredTree(composite, 0x800 | (this.useCheckboxTree ? 32 : 0), new PatternFilter(), true, true);
        this.filteredTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.getViewer().setContentProvider((IContentProvider)new MavenContainerContentProvider());
        this.getViewer().setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.getViewer().setInput((Object)ResourcesPlugin.getWorkspace());
        this.getViewer().addDoubleClickListener(event -> this.okPressed());
        return composite;
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected TreeViewer getViewer() {
        return this.filteredTree.getViewer();
    }

    protected static class MavenContainerContentProvider
    implements ITreeContentProvider {
        protected MavenContainerContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            IContainer container;
            if (parent instanceof IWorkspace) {
                IWorkspace workspace = (IWorkspace)parent;
                IProject[] projects = workspace.getRoot().getProjects();
                ArrayList<IProject> children = new ArrayList<IProject>();
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    try {
                        if (project.isOpen() && project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                            children.add(project);
                        }
                    }
                    catch (CoreException e) {
                        log.error("Error checking project: " + e.getMessage(), (Throwable)e);
                    }
                    ++n2;
                }
                return children.toArray();
            }
            if (parent instanceof IContainer && (container = (IContainer)parent).isAccessible()) {
                try {
                    IResource[] members;
                    ArrayList<IResource> children = new ArrayList<IResource>();
                    IResource[] iResourceArray = members = container.members();
                    int n = members.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IContainer memberContainer;
                        IResource member = iResourceArray[n3];
                        if (member instanceof IContainer && (memberContainer = (IContainer)member).exists(IPath.fromOSString((String)"pom.xml"))) {
                            children.add(member);
                        }
                        ++n3;
                    }
                    return children.toArray();
                }
                catch (CoreException e) {
                    log.error("Error checking container: " + e.getMessage(), (Throwable)e);
                }
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IResource) {
                IResource resource = (IResource)element;
                return resource.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object arg1, Object arg2) {
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }
    }
}

