/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.view.ui.internal.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.terminal.view.ui.internal.Messages;

public class NoteCompositeHelper {
    public static final String NOTE_LABEL = Messages.NoteCompositeHelper_note_label;

    public static Composite createNoteComposite(Font font, Composite composite, String title, String message) {
        return NoteCompositeHelper.createNoteComposite(font, composite, title, message, -1);
    }

    public static Composite createNoteComposite(Font font, Composite composite, String title, String message, int minCharsPerLine) {
        GC gc = new GC((Drawable)composite);
        gc.setFont(font);
        NoteComposite messageComposite = new NoteComposite(composite, 0);
        GridLayout messageLayout = new GridLayout();
        messageLayout.numColumns = 2;
        messageLayout.marginWidth = 0;
        messageLayout.marginHeight = 0;
        messageComposite.setLayout((Layout)messageLayout);
        GridData layoutData = new GridData(256);
        if (composite.getLayout() instanceof GridLayout) {
            layoutData.horizontalSpan = ((GridLayout)composite.getLayout()).numColumns;
        }
        messageComposite.setLayoutData(layoutData);
        messageComposite.setFont(font);
        Label noteLabel = new Label((Composite)messageComposite, 1);
        noteLabel.setText(title);
        noteLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        noteLabel.setLayoutData((Object)new GridData(2));
        IPropertyChangeListener fontListener = event -> {
            if ("org.eclipse.jface.bannerfont".equals(event.getProperty())) {
                noteLabel.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
            }
        };
        JFaceResources.getFontRegistry().addListener(fontListener);
        noteLabel.addDisposeListener(event -> JFaceResources.getFontRegistry().removeListener(fontListener));
        Label messageLabel = new Label((Composite)messageComposite, 64);
        messageLabel.setText(message);
        messageLabel.setFont(font);
        layoutData = new GridData(768);
        layoutData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)(minCharsPerLine >= 20 ? minCharsPerLine : 65));
        messageLabel.setLayoutData((Object)layoutData);
        gc.dispose();
        return messageComposite;
    }

    public static void setMessage(Composite messageComposite, String msg) {
        Control c;
        Control[] children;
        if (messageComposite instanceof NoteComposite && (children = messageComposite.getChildren()).length == 2 && (c = children[1]) instanceof Label) {
            ((Label)c).setText(msg);
            messageComposite.pack();
        }
    }

    private static class NoteComposite
    extends Composite {
        public NoteComposite(Composite parent, int style) {
            super(parent, style);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            Control[] controlArray = this.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.setEnabled(enabled);
                ++n2;
            }
        }
    }
}

