/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.PluginActionSet;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.IActionSet;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ActionSetDescriptor
implements IActionSetDescriptor,
IAdaptable,
IWorkbenchAdapter,
IPluginContribution {
    private static final Object[] NO_CHILDREN = new Object[0];
    private static final String INITIALLY_HIDDEN_PREF_ID_PREFIX = "actionSet.initiallyHidden.";
    private final String id;
    private final String pluginId;
    private final String label;
    private boolean visible;
    private final String description;
    private final IConfigurationElement configElement;

    public ActionSetDescriptor(IConfigurationElement configElement) throws CoreException {
        this.configElement = configElement;
        this.id = configElement.getAttribute("id");
        this.pluginId = configElement.getNamespace();
        this.label = configElement.getAttribute("label");
        this.description = configElement.getAttribute("description");
        String str = configElement.getAttribute("visible");
        if (str != null && str.equals("true")) {
            this.visible = true;
        }
        if (this.label == null) {
            throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "Invalid extension (missing label): " + this.id, null));
        }
    }

    @Override
    public IActionSet createActionSet() {
        return new PluginActionSet(this);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return adapter.cast(this);
        }
        return null;
    }

    @Override
    public Object[] getChildren(Object o) {
        return NO_CHILDREN;
    }

    @Override
    public IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getLabel(Object o) {
        if (o == this) {
            return this.getLabel();
        }
        return "Unknown Label";
    }

    @Override
    public boolean isInitiallyVisible() {
        String prefId;
        if (this.id == null) {
            return this.visible;
        }
        Preferences prefs = WorkbenchPlugin.getDefault().getPluginPreferences();
        if (prefs.getBoolean(prefId = INITIALLY_HIDDEN_PREF_ID_PREFIX + this.getId())) {
            return false;
        }
        return this.visible;
    }

    @Override
    public void setInitiallyVisible(boolean newValue) {
        if (this.id == null) {
            return;
        }
        Preferences prefs = WorkbenchPlugin.getDefault().getPluginPreferences();
        String prefId = INITIALLY_HIDDEN_PREF_ID_PREFIX + this.getId();
        prefs.setValue(prefId, !newValue);
    }

    @Override
    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    @Override
    public Object getParent(Object o) {
        return null;
    }

    @Override
    public String getLocalId() {
        return this.id;
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object arg0) {
        void descr;
        if (!(arg0 instanceof ActionSetDescriptor)) {
            return false;
        }
        ActionSetDescriptor actionSetDescriptor = (ActionSetDescriptor)arg0;
        return this.id.equals(descr.id) && descr.pluginId.equals(this.pluginId);
    }

    public int hashCode() {
        return this.id.hashCode() + this.pluginId.hashCode();
    }

    public String toString() {
        return "ActionSetDescriptor [id=" + this.id + ", visible=" + this.visible + "]";
    }
}

