/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support.conversion;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.support.conversion.ConversionException;
import org.junit.platform.commons.support.conversion.FallbackStringToObjectConverter;
import org.junit.platform.commons.support.conversion.StringToBooleanConverter;
import org.junit.platform.commons.support.conversion.StringToCharacterConverter;
import org.junit.platform.commons.support.conversion.StringToClassConverter;
import org.junit.platform.commons.support.conversion.StringToCommonJavaTypesConverter;
import org.junit.platform.commons.support.conversion.StringToEnumConverter;
import org.junit.platform.commons.support.conversion.StringToJavaTimeConverter;
import org.junit.platform.commons.support.conversion.StringToNumberConverter;
import org.junit.platform.commons.support.conversion.StringToObjectConverter;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.MAINTAINED, since="1.13.3")
public final class ConversionSupport {
    private static final List<StringToObjectConverter> stringToObjectConverters = Collections.unmodifiableList(Arrays.asList(new StringToBooleanConverter(), new StringToCharacterConverter(), new StringToNumberConverter(), new StringToClassConverter(), new StringToEnumConverter(), new StringToJavaTimeConverter(), new StringToCommonJavaTypesConverter(), new FallbackStringToObjectConverter()));

    private ConversionSupport() {
    }

    public static <T> T convert(String source, Class<T> targetType, ClassLoader classLoader) {
        if (source == null) {
            if (targetType.isPrimitive()) {
                throw new ConversionException("Cannot convert null to primitive value of type " + targetType.getTypeName());
            }
            return null;
        }
        if (String.class.equals(targetType)) {
            return (T)source;
        }
        Class<?> targetTypeToUse = ConversionSupport.toWrapperType(targetType);
        Optional<StringToObjectConverter> converter = stringToObjectConverters.stream().filter(candidate -> candidate.canConvertTo(targetTypeToUse)).findFirst();
        if (converter.isPresent()) {
            try {
                ClassLoader classLoaderToUse = classLoader != null ? classLoader : ClassLoaderUtils.getDefaultClassLoader();
                return (T)converter.get().convert(source, targetTypeToUse, classLoaderToUse);
            }
            catch (Exception ex) {
                if (ex instanceof ConversionException) {
                    throw (ConversionException)ex;
                }
                throw new ConversionException(String.format("Failed to convert String \"%s\" to type %s", source, targetType.getTypeName()), ex);
            }
        }
        throw new ConversionException("No built-in converter for source type java.lang.String and target type " + targetType.getTypeName());
    }

    private static Class<?> toWrapperType(Class<?> targetType) {
        Class<?> wrapperType = ReflectionUtils.getWrapperType(targetType);
        return wrapperType != null ? wrapperType : targetType;
    }
}

