/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.coverageview;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IMemento;
import org.jacoco.core.analysis.ICoverageNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewSettings {
    private static final String KEY_SORTCOLUMN = "sortcolumn";
    private static final String KEY_REVERSESORT = "reversesort";
    private static final String KEY_COUNTERS = "counters";
    private static final String KEY_HIDEUNUSEDELEMENTS = "hideunusedelements";
    private static final String KEY_ROOTTYPE = "roottype";
    private static final String KEY_COLUMN0 = "column0";
    private static final String KEY_COLUMN1 = "column1";
    private static final String KEY_COLUMN2 = "column2";
    private static final String KEY_COLUMN3 = "column3";
    private static final String KEY_COLUMN4 = "column4";
    private static final String KEY_LINKED = "linked";
    private static final Map<ICoverageNode.CounterEntity, String[]> COLUMNS_HEADERS = new HashMap<ICoverageNode.CounterEntity, String[]>();
    private static final int[] DEFAULT_COLUMNWIDTH;
    private int sortcolumn;
    private boolean reversesort;
    private ICoverageNode.CounterEntity counters;
    private ICoverageNode.ElementType roottype;
    private boolean hideunusedelements;
    private int[] columnwidths = new int[5];
    private boolean linked;

    static {
        COLUMNS_HEADERS.put(ICoverageNode.CounterEntity.INSTRUCTION, new String[]{UIMessages.CoverageViewColumnElement_label, UIMessages.CoverageViewColumnCoverage_label, UIMessages.CoverageViewColumnCoveredInstructions_label, UIMessages.CoverageViewColumnMissedInstructions_label, UIMessages.CoverageViewColumnTotalInstructions_label});
        COLUMNS_HEADERS.put(ICoverageNode.CounterEntity.BRANCH, new String[]{UIMessages.CoverageViewColumnElement_label, UIMessages.CoverageViewColumnCoverage_label, UIMessages.CoverageViewColumnCoveredBranches_label, UIMessages.CoverageViewColumnMissedBranches_label, UIMessages.CoverageViewColumnTotalBranches_label});
        COLUMNS_HEADERS.put(ICoverageNode.CounterEntity.LINE, new String[]{UIMessages.CoverageViewColumnElement_label, UIMessages.CoverageViewColumnCoverage_label, UIMessages.CoverageViewColumnCoveredLines_label, UIMessages.CoverageViewColumnMissedLines_label, UIMessages.CoverageViewColumnTotalLines_label});
        COLUMNS_HEADERS.put(ICoverageNode.CounterEntity.METHOD, new String[]{UIMessages.CoverageViewColumnElement_label, UIMessages.CoverageViewColumnCoverage_label, UIMessages.CoverageViewColumnCoveredMethods_label, UIMessages.CoverageViewColumnMissedMethods_label, UIMessages.CoverageViewColumnTotalMethods_label});
        COLUMNS_HEADERS.put(ICoverageNode.CounterEntity.CLASS, new String[]{UIMessages.CoverageViewColumnElement_label, UIMessages.CoverageViewColumnCoverage_label, UIMessages.CoverageViewColumnCoveredTypes_label, UIMessages.CoverageViewColumnMissedTypes_label, UIMessages.CoverageViewColumnTotalTypes_label});
        COLUMNS_HEADERS.put(ICoverageNode.CounterEntity.COMPLEXITY, new String[]{UIMessages.CoverageViewColumnElement_label, UIMessages.CoverageViewColumnCoverage_label, UIMessages.CoverageViewColumnCoveredComplexity_label, UIMessages.CoverageViewColumnMissedComplexity_label, UIMessages.CoverageViewColumnTotalComplexity_label});
        DEFAULT_COLUMNWIDTH = new int[]{300, 80, 120, 120, 120};
    }

    public int getSortColumn() {
        return this.sortcolumn;
    }

    public boolean isReverseSort() {
        return this.reversesort;
    }

    public void toggleSortColumn(int column) {
        if (this.sortcolumn == column) {
            this.reversesort = !this.reversesort;
        } else {
            this.reversesort = false;
            this.sortcolumn = column;
        }
    }

    public String[] getColumnHeaders() {
        return COLUMNS_HEADERS.get(this.counters);
    }

    public ICoverageNode.CounterEntity getCounters() {
        return this.counters;
    }

    public void setCounters(ICoverageNode.CounterEntity counters) {
        this.counters = counters;
    }

    public ICoverageNode.ElementType getRootType() {
        return this.roottype;
    }

    public void setRootType(ICoverageNode.ElementType roottype) {
        this.roottype = roottype;
    }

    public boolean getHideUnusedElements() {
        return this.hideunusedelements;
    }

    public void setHideUnusedElements(boolean flag) {
        this.hideunusedelements = flag;
    }

    public void storeColumnWidth(TreeViewer viewer) {
        TreeColumn[] columns = viewer.getTree().getColumns();
        int i = 0;
        while (i < this.columnwidths.length) {
            this.columnwidths[i] = columns[i].getWidth();
            ++i;
        }
    }

    public void restoreColumnWidth(TreeViewer viewer) {
        TreeColumn[] columns = viewer.getTree().getColumns();
        int i = 0;
        while (i < this.columnwidths.length) {
            columns[i].setWidth(this.columnwidths[i]);
            ++i;
        }
    }

    public void updateColumnHeaders(TreeViewer viewer) {
        String[] headers = COLUMNS_HEADERS.get(this.counters);
        TreeColumn[] columns = viewer.getTree().getColumns();
        int i = 0;
        while (i < headers.length) {
            columns[i].setText(headers[i]);
            ++i;
        }
    }

    public boolean isLinked() {
        return this.linked;
    }

    public void setLinked(boolean linked) {
        this.linked = linked;
    }

    public void init(IMemento memento) {
        this.sortcolumn = this.getInt(memento, KEY_SORTCOLUMN, 3);
        this.reversesort = this.getBoolean(memento, KEY_REVERSESORT, true);
        this.counters = this.getEnum(memento, KEY_COUNTERS, ICoverageNode.CounterEntity.class, ICoverageNode.CounterEntity.INSTRUCTION);
        this.roottype = this.getEnum(memento, KEY_ROOTTYPE, ICoverageNode.ElementType.class, ICoverageNode.ElementType.GROUP);
        this.hideunusedelements = this.getBoolean(memento, KEY_HIDEUNUSEDELEMENTS, false);
        this.columnwidths[0] = this.getWidth(memento, KEY_COLUMN0, DEFAULT_COLUMNWIDTH[0]);
        this.columnwidths[1] = this.getWidth(memento, KEY_COLUMN1, DEFAULT_COLUMNWIDTH[1]);
        this.columnwidths[2] = this.getWidth(memento, KEY_COLUMN2, DEFAULT_COLUMNWIDTH[2]);
        this.columnwidths[3] = this.getWidth(memento, KEY_COLUMN3, DEFAULT_COLUMNWIDTH[3]);
        this.columnwidths[4] = this.getWidth(memento, KEY_COLUMN4, DEFAULT_COLUMNWIDTH[4]);
        this.linked = this.getBoolean(memento, KEY_LINKED, false);
    }

    public void save(IMemento memento) {
        memento.putInteger(KEY_SORTCOLUMN, this.sortcolumn);
        memento.putBoolean(KEY_REVERSESORT, this.reversesort);
        memento.putString(KEY_COUNTERS, this.counters.name());
        memento.putString(KEY_ROOTTYPE, this.roottype.name());
        memento.putBoolean(KEY_HIDEUNUSEDELEMENTS, this.hideunusedelements);
        memento.putInteger(KEY_COLUMN0, this.columnwidths[0]);
        memento.putInteger(KEY_COLUMN1, this.columnwidths[1]);
        memento.putInteger(KEY_COLUMN2, this.columnwidths[2]);
        memento.putInteger(KEY_COLUMN3, this.columnwidths[3]);
        memento.putInteger(KEY_COLUMN4, this.columnwidths[4]);
        memento.putBoolean(KEY_LINKED, this.linked);
    }

    private int getWidth(IMemento memento, String key, int preset) {
        int w = this.getInt(memento, key, preset);
        return w == 0 ? preset : w;
    }

    private int getInt(IMemento memento, String key, int preset) {
        if (memento == null) {
            return preset;
        }
        Integer i = memento.getInteger(key);
        return i == null ? preset : i;
    }

    private boolean getBoolean(IMemento memento, String key, boolean preset) {
        if (memento == null) {
            return preset;
        }
        Boolean b = memento.getBoolean(key);
        return b == null ? preset : b;
    }

    private <T extends Enum<T>> T getEnum(IMemento memento, String key, Class<T> type, T preset) {
        if (memento == null) {
            return preset;
        }
        String s = memento.getString(key);
        if (s == null) {
            return preset;
        }
        try {
            return Enum.valueOf(type, s);
        }
        catch (IllegalArgumentException e) {
            return preset;
        }
    }
}

