/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.editors;

import org.eclipse.jface.viewers.AcceptAllFilter;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.runtime.WildcardMatcher;

final class ExecutedClassesFilters {
    public static ViewerFilter fromPatternString(final String pattern) {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return ExecutedClassesFilters.filterFromPatternString(pattern).select(element);
            }
        };
    }

    public static IFilter filterFromPatternString(String pattern) {
        if (pattern.length() == 0) {
            return AcceptAllFilter.getInstance();
        }
        if (pattern.startsWith("0x")) {
            return new ClassIdMatcher(pattern);
        }
        return new ClassNameMatcher(pattern);
    }

    private ExecutedClassesFilters() {
    }

    private static class ClassIdMatcher
    extends PatternMatchingFilter {
        public ClassIdMatcher(String patternString) {
            super(patternString);
        }

        protected String getMatchedValue(Object toTest) {
            return String.format("0x%016x", ((ExecutionData)toTest).getId());
        }
    }

    private static class ClassNameMatcher
    extends PatternMatchingFilter {
        public ClassNameMatcher(String patternString) {
            super(patternString);
        }

        protected String getMatchedValue(Object toTest) {
            return ((ExecutionData)toTest).getName();
        }
    }

    private static abstract class PatternMatchingFilter
    implements IFilter {
        private WildcardMatcher matcher;

        public PatternMatchingFilter(String patternString) {
            this.matcher = new WildcardMatcher(patternString);
        }

        public boolean select(Object toTest) {
            return this.matcher.matches(this.getMatchedValue(toTest));
        }

        protected abstract String getMatchedValue(Object var1);
    }
}

