/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.jreinfo.ui;

import org.eclipse.oomph.jreinfo.JRE;
import org.eclipse.oomph.jreinfo.JREFilter;
import org.eclipse.oomph.jreinfo.ui.JREComposite;
import org.eclipse.oomph.jreinfo.ui.JREInfoUIPlugin;
import org.eclipse.oomph.jreinfo.ui.Messages;
import org.eclipse.oomph.ui.OomphDialog;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.Request;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class JREDialog
extends OomphDialog {
    public static final String TITLE = Messages.JREDialog_title;
    private final Request.Handler downloadHandler;
    private JREFilter filter;
    private Object selectedElement;
    private JREComposite composite;
    private OS os = OS.INSTANCE;

    public JREDialog(Shell parentShell, Request.Handler downloadHandler) {
        super(parentShell, TITLE, 600, 500, (OomphUIPlugin)JREInfoUIPlugin.INSTANCE, false);
        this.downloadHandler = downloadHandler;
        this.setShellStyle(68656);
    }

    public JREFilter getJREFilter() {
        return this.filter;
    }

    public void setJREFilter(JREFilter filter) {
        this.filter = filter;
        UIUtil.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                JREDialog.this.setMessage(JREDialog.this.getDefaultMessage());
            }
        });
    }

    public OS getOS() {
        return this.os;
    }

    public void setOS(OS os) {
        this.os = os;
    }

    public Object getSelectedElement() {
        if (this.composite == null) {
            return this.selectedElement;
        }
        return this.composite.getSelectedElement();
    }

    public void setSelectedElement(Object selectedElement) {
        this.selectedElement = selectedElement;
    }

    public final JREComposite getComposite() {
        return this.composite;
    }

    protected String getShellText() {
        return TITLE;
    }

    protected String getDefaultMessage() {
        if (this.filter != null) {
            return NLS.bind((String)Messages.JREDialog_selectJvm_withFilter, (Object)this.filter.toString());
        }
        return Messages.JREDialog_selectJvm;
    }

    protected String getImagePath() {
        return "library_wiz.png";
    }

    protected int getContainerMargin() {
        return 5;
    }

    protected void createUI(Composite parent) {
        this.getShell().setImage(JREInfoUIPlugin.INSTANCE.getSWTImage("jre"));
        this.composite = new JREComposite(parent, 0, this.downloadHandler, this.filter, this.selectedElement){

            @Override
            protected void elementChanged(Object element) {
                super.elementChanged(element);
                JREDialog.this.elementChanged(element);
            }

            @Override
            protected void doubleClicked(JRE jre) {
                JREDialog.this.close();
            }
        };
        this.composite.setOs(this.getOS());
        this.composite.setLayoutData(new GridData(1808));
    }

    protected void elementChanged(Object element) {
    }
}

