/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare;

import java.util.ResourceBundle;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class NavigationAction
extends Action {
    private final boolean fNext;
    private CompareEditorInput fCompareEditorInput;

    public NavigationAction(boolean next) {
        this(CompareUI.getResourceBundle(), next);
    }

    public NavigationAction(ResourceBundle bundle, boolean next) {
        Utilities.initAction((IAction)this, bundle, next ? "action.Next." : "action.Previous.");
        this.fNext = next;
    }

    public void run() {
        ICompareNavigator adapter;
        if (this.fCompareEditorInput != null && (adapter = this.fCompareEditorInput.getAdapter(ICompareNavigator.class)) instanceof ICompareNavigator) {
            boolean atEnd = adapter.selectChange(this.fNext);
            Shell shell = CompareUIPlugin.getShell();
            if (atEnd && shell != null) {
                String message;
                String title;
                Display display = shell.getDisplay();
                if (display != null) {
                    display.beep();
                }
                if (this.fNext) {
                    title = CompareMessages.CompareNavigator_atEnd_title;
                    message = CompareMessages.CompareNavigator_atEnd_message;
                } else {
                    title = CompareMessages.CompareNavigator_atBeginning_title;
                    message = CompareMessages.CompareNavigator_atBeginning_message;
                }
                MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
            }
        }
    }

    public void setCompareEditorInput(CompareEditorInput input) {
        this.fCompareEditorInput = input;
    }
}

