/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.CompositeDebugImageDescriptor;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class BreakpointsLabelProvider
extends LabelProvider
implements IFontProvider {
    private final WorkbenchLabelProvider fWorkbenchLabelProvider = new WorkbenchLabelProvider();
    private final IDebugModelPresentation fPresentation = DebugUITools.newDebugModelPresentation();

    public void dispose() {
        this.fWorkbenchLabelProvider.dispose();
        this.fPresentation.dispose();
        super.dispose();
    }

    public Image getImage(Object element) {
        int flags;
        if (element instanceof IBreakpoint) {
            return this.fPresentation.getImage(element);
        }
        Image image = this.fWorkbenchLabelProvider.getImage(element);
        if (image != null && (flags = this.computeAdornmentFlags()) > 0) {
            CompositeDebugImageDescriptor descriptor = new CompositeDebugImageDescriptor(image, flags);
            return DebugUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)descriptor);
        }
        return image;
    }

    private int computeAdornmentFlags() {
        if (!DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
            return 1;
        }
        return 0;
    }

    public String getText(Object element) {
        if (element instanceof IBreakpoint) {
            return this.fPresentation.getText(element);
        }
        return this.fWorkbenchLabelProvider.getText(element);
    }

    public Font getFont(Object element) {
        if (element instanceof IBreakpoint) {
            return null;
        }
        return this.fWorkbenchLabelProvider.getFont(element);
    }

    public IDebugModelPresentation getPresentation() {
        return this.fPresentation;
    }
}

