/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IBreakpointImportParticipant;
import org.eclipse.debug.internal.core.BreakpointManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class ImportBreakpointsOperation
implements IRunnableWithProgress {
    private boolean fOverwriteAll = false;
    private String fFileName = null;
    private boolean fCreateWorkingSets = false;
    private final ArrayList<IBreakpoint> fAdded = new ArrayList();
    private String fCurrentWorkingSetProperty = null;
    private final BreakpointManager fManager = (BreakpointManager)DebugPlugin.getDefault().getBreakpointManager();
    private StringBuffer fBuffer = null;
    private boolean fImportBreakpoints = true;

    public ImportBreakpointsOperation(String fileName, boolean overwrite, boolean createWorkingSets) {
        this(fileName, overwrite, createWorkingSets, true);
    }

    public ImportBreakpointsOperation(String fileName, boolean overwrite, boolean createWorkingSets, boolean importBreakpoints) {
        this.fFileName = fileName;
        this.fOverwriteAll = overwrite;
        this.fCreateWorkingSets = createWorkingSets;
        this.fImportBreakpoints = importBreakpoints;
    }

    public ImportBreakpointsOperation(StringBuffer buffer, boolean overwrite, boolean createWorkingSets) {
        this(buffer, overwrite, createWorkingSets, true);
    }

    public ImportBreakpointsOperation(StringBuffer buffer, boolean overwrite, boolean createWorkingSets, boolean importBreakpoints) {
        this.fBuffer = buffer;
        this.fOverwriteAll = overwrite;
        this.fCreateWorkingSets = createWorkingSets;
        this.fImportBreakpoints = importBreakpoints;
    }

    /*
     * Exception decompiling
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [23[WHILELOOP]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected IMarker findExistingMarker(Map<String, Object> attributes, IBreakpointImportParticipant[] participants) {
        IBreakpoint[] bps;
        IBreakpoint[] iBreakpointArray = bps = this.fManager.getBreakpoints();
        int n = bps.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp = iBreakpointArray[n2];
            IBreakpointImportParticipant[] iBreakpointImportParticipantArray = participants;
            int n3 = participants.length;
            int n4 = 0;
            while (n4 < n3) {
                IBreakpointImportParticipant participant = iBreakpointImportParticipantArray[n4];
                try {
                    if (participant.matches(attributes, bp)) {
                        return bp.getMarker();
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    protected Map<String, Object> collectBreakpointProperties(IMemento memento) {
        IMemento[] children;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enabled", memento.getBoolean("enabled"));
        if (memento.getBoolean("persistent") != null) {
            map.put("persistent", memento.getBoolean("persistent"));
        } else {
            map.put("persistent", memento.getBoolean("persistant"));
        }
        map.put("registered", memento.getBoolean("registered"));
        IMemento child = memento.getChild("marker");
        map.put("type", child.getString("type"));
        map.put("lineNumber", child.getInteger("lineNumber"));
        IMemento[] iMementoArray = children = child.getChildren("attrib");
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento c = iMementoArray[n2];
            this.readAttribute(c, map);
            ++n2;
        }
        child = memento.getChild("resource");
        map.put("path", child.getString("path"));
        return map;
    }

    private void readAttribute(IMemento memento, Map<String, Object> map) {
        String name = memento.getString("name");
        String value = memento.getString("value");
        if (value != null && name != null) {
            Object val;
            block5: {
                if (name.equals("workingset_name")) {
                    this.fCurrentWorkingSetProperty = value;
                }
                val = value;
                try {
                    val = Integer.valueOf(value);
                }
                catch (NumberFormatException e) {
                    if (!value.equalsIgnoreCase("false") && !value.equalsIgnoreCase("true")) break block5;
                    val = Boolean.valueOf(value);
                }
            }
            if (val != null) {
                map.put(name, val);
            }
        }
    }

    protected void restoreBreakpoint(IMarker marker, Map<String, Object> attributes, IBreakpointImportParticipant[] participants) {
        block10: {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                try {
                    marker.setAttribute(entry.getKey(), entry.getValue());
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            IBreakpoint breakpoint = null;
            try {
                breakpoint = this.fManager.createBreakpoint(marker);
                breakpoint.setEnabled(((Boolean)attributes.get("enabled")).booleanValue());
                breakpoint.setPersisted(((Boolean)attributes.get("persistent")).booleanValue());
                breakpoint.setRegistered(((Boolean)attributes.get("registered")).booleanValue());
                this.fAdded.add(breakpoint);
                if (this.fImportBreakpoints && this.fCreateWorkingSets && this.fCurrentWorkingSetProperty != null) {
                    String[] names = this.fCurrentWorkingSetProperty.split("\\<;#>");
                    this.updateWorkingSets(names, breakpoint);
                }
                if (participants != null) {
                    IBreakpointImportParticipant[] iBreakpointImportParticipantArray = participants;
                    int n = participants.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBreakpointImportParticipant participant = iBreakpointImportParticipantArray[n2];
                        participant.verify(breakpoint);
                        ++n2;
                    }
                }
            }
            catch (CoreException ce) {
                if (breakpoint == null) break block10;
                try {
                    this.fAdded.remove(breakpoint);
                    marker.delete();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    }

    private void updateWorkingSets(String[] wsnames, IBreakpoint breakpoint) {
        IWorkingSetManager mgr = PlatformUI.getWorkbench().getWorkingSetManager();
        ArrayList<IWorkingSet> sets = new ArrayList<IWorkingSet>();
        this.collectContainingWorkingsets(breakpoint, sets);
        String[] stringArray = wsnames;
        int n = wsnames.length;
        int n2 = 0;
        while (n2 < n) {
            String wsname = stringArray[n2];
            if (!"".equals(wsname)) {
                IWorkingSet set = mgr.getWorkingSet(wsname);
                if (set == null) {
                    set = mgr.createWorkingSet(wsname, new IAdaptable[0]);
                    set.setId("org.eclipse.debug.ui.breakpointWorkingSet");
                    mgr.addWorkingSet(set);
                }
                if (!sets.contains(set)) {
                    IAdaptable[] elements = set.getElements();
                    IAdaptable[] newElements = new IAdaptable[elements.length + 1];
                    newElements[newElements.length - 1] = breakpoint;
                    System.arraycopy(elements, 0, newElements, 0, elements.length);
                    set.setElements(newElements);
                }
                sets.remove(set);
            }
            ++n2;
        }
        ArrayList<IAdaptable> items = null;
        for (IWorkingSet set : sets) {
            items = new ArrayList<IAdaptable>(Arrays.asList(set.getElements()));
            if (!items.remove(breakpoint)) continue;
            set.setElements(items.toArray(new IAdaptable[items.size()]));
        }
    }

    private void collectContainingWorkingsets(IBreakpoint breakpoint, List<IWorkingSet> collector) {
        IWorkingSet[] sets;
        IWorkingSetManager mgr = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet[] iWorkingSetArray = sets = mgr.getWorkingSets();
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet set = iWorkingSetArray[n2];
            if ("org.eclipse.debug.ui.breakpointWorkingSet".equals(set.getId()) && this.containsBreakpoint(set, breakpoint)) {
                collector.add(set);
            }
            ++n2;
        }
    }

    private boolean containsBreakpoint(IWorkingSet set, IBreakpoint breakpoint) {
        IAdaptable[] elements;
        IAdaptable[] iAdaptableArray = elements = set.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable element = iAdaptableArray[n2];
            if (element.equals(breakpoint)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IBreakpoint[] getImportedBreakpoints() {
        return this.fAdded.toArray(new IBreakpoint[this.fAdded.size()]);
    }
}

