/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.DayDateRange;
import org.eclipse.mylyn.internal.tasks.core.Messages;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;

public class WeekDateRange
extends DateRange {
    private static final String DESCRIPTION_WEEK_AFTER_NEXT = Messages.WeekDateRange_Two_Weeks;
    private static final String DESCRIPTION_PREVIOUS_WEEK = Messages.WeekDateRange_Previous_Week;
    private static final String DESCRIPTION_THIS_WEEK = Messages.WeekDateRange_This_Week;
    private static final String DESCRIPTION_NEXT_WEEK = Messages.WeekDateRange_Next_Week;
    private final List<DayDateRange> days = new ArrayList<DayDateRange>();

    public WeekDateRange(Calendar startDate, Calendar endDate) {
        super(startDate, endDate);
    }

    public List<DateRange> getRemainingDays() {
        ArrayList<DateRange> remainingDays = new ArrayList<DateRange>();
        for (DateRange dateRange : this.getDaysOfWeek()) {
            if (dateRange.isPast()) continue;
            remainingDays.add(dateRange);
        }
        return remainingDays;
    }

    public List<DayDateRange> getDaysOfWeek() {
        if (this.days.isEmpty()) {
            int x = TaskActivityUtil.getStartDay();
            while (x < TaskActivityUtil.getStartDay() + 7) {
                Calendar dayStart = TaskActivityUtil.getCalendar();
                dayStart.setTime(this.getStartDate().getTime());
                TaskActivityUtil.snapStartOfDay(dayStart);
                Calendar dayEnd = TaskActivityUtil.getCalendar();
                dayEnd.setTime(this.getStartDate().getTime());
                TaskActivityUtil.snapEndOfDay(dayEnd);
                if (x > 7) {
                    dayStart.set(7, x % 7);
                    dayEnd.set(7, x % 7);
                } else {
                    dayStart.set(7, x);
                    dayEnd.set(7, x);
                }
                this.days.add(new DayDateRange(dayStart, dayEnd));
                ++x;
            }
        }
        return this.days;
    }

    public DayDateRange getToday() {
        DayDateRange today = null;
        Calendar now = TaskActivityUtil.getCalendar();
        for (DayDateRange range : this.getDaysOfWeek()) {
            if (!range.includes(now)) continue;
            today = range;
            break;
        }
        if (today == null) {
            Calendar todayStart = TaskActivityUtil.getCalendar();
            TaskActivityUtil.snapStartOfDay(todayStart);
            Calendar todayEnd = TaskActivityUtil.getCalendar();
            TaskActivityUtil.snapEndOfDay(todayEnd);
            today = new DayDateRange(todayStart, todayEnd);
        }
        return today;
    }

    public boolean isCurrentWeekDay(DateRange range) {
        if (range == null) {
            return false;
        }
        return this.getDaysOfWeek().contains(range);
    }

    private boolean isNextWeek() {
        return TaskActivityUtil.getNextWeek().compareTo(this) == 0;
    }

    public boolean isThisWeek() {
        return this.includes(Calendar.getInstance());
    }

    private boolean isPreviousWeek() {
        Calendar cal = Calendar.getInstance();
        cal.add(3, -1);
        return this.includes(cal);
    }

    boolean isWeekAfterNext() {
        return TaskActivityUtil.getNextWeek().next().compareTo(this) == 0;
    }

    public WeekDateRange next() {
        return this.create(3, 1);
    }

    public WeekDateRange previous() {
        return this.create(3, -1);
    }

    protected WeekDateRange create(int field, int multiplier) {
        Calendar previousStart = (Calendar)this.getStartDate().clone();
        Calendar previousEnd = (Calendar)this.getEndDate().clone();
        previousStart.add(field, 1 * multiplier);
        previousEnd.add(field, 1 * multiplier);
        return new WeekDateRange(previousStart, previousEnd);
    }

    @Override
    public String toString(boolean useDayOfWeekForNextWeek) {
        if (this.isWeekAfterNext()) {
            return DESCRIPTION_WEEK_AFTER_NEXT;
        }
        if (this.isThisWeek()) {
            return DESCRIPTION_THIS_WEEK;
        }
        if (this.isNextWeek()) {
            return DESCRIPTION_NEXT_WEEK;
        }
        if (this.isPreviousWeek()) {
            return DESCRIPTION_PREVIOUS_WEEK;
        }
        return super.toString(useDayOfWeekForNextWeek);
    }

    public DateRange getDayOfWeek(int dayNum) {
        if (dayNum > 0 && dayNum <= 7) {
            for (DateRange dateRange : this.getDaysOfWeek()) {
                if (dateRange.getStartDate().get(7) != dayNum) continue;
                return dateRange;
            }
        }
        throw new IllegalArgumentException("Valid day values are 1 - 7");
    }

    public static boolean isWeekRange(Calendar calStart, Calendar calEnd) {
        long diff = calEnd.getTimeInMillis() - calStart.getTimeInMillis() - 604799999L;
        return Math.abs(diff) <= 3600000L;
    }
}

