/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.mylyn.internal.commons.core.XmlStringConverter;
import org.eclipse.mylyn.internal.tasks.core.externalization.AttributesWrapper;
import org.eclipse.mylyn.internal.tasks.core.externalization.ContentHandlerWrapper;
import org.eclipse.mylyn.tasks.core.IAttributeContainer;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.xml.sax.SAXException;

public abstract class SaxTaskListElementWriter<T extends IRepositoryElement> {
    protected final ContentHandlerWrapper handler;
    private final MultiStatus errors;

    public SaxTaskListElementWriter(ContentHandlerWrapper handler) {
        this.handler = handler;
        this.errors = new MultiStatus("org.eclipse.mylyn.tasks.core", 0, null, null);
    }

    public abstract void writeElement(T var1) throws SAXException;

    protected void writeAttributes(IAttributeContainer container) throws SAXException {
        Map<String, String> attributes = container.getAttributes();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            AttributesWrapper xmlAttributes = new AttributesWrapper();
            xmlAttributes.addAttribute("Key", entry.getKey());
            this.handler.startElement("Attribute", xmlAttributes);
            this.handler.characters(entry.getValue());
            this.handler.endElement("Attribute");
        }
    }

    protected String stripControlCharacters(String text) {
        if (text == null) {
            return "";
        }
        return XmlStringConverter.cleanXmlString((String)text);
    }

    protected String formatExternDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S Z", Locale.ENGLISH);
        return format.format(date);
    }

    protected String formatExternCalendar(Calendar date) {
        if (date == null) {
            return "";
        }
        return this.formatExternDate(date.getTime());
    }

    protected void addError(IStatus status) {
        this.errors.add(status);
    }

    public IStatus getErrors() {
        return this.errors;
    }
}

