/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.format;

import java.util.ArrayList;
import org.eclipse.compare.internal.DocLineComparator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;

public interface IFormatRegionsProvider {
    public IRegion @Nullable [] getFormattingRegions(IDocument var1);

    public static IRegion[] allLines(IDocument document) {
        return new IRegion[]{new Region(0, document.getLength())};
    }

    public static IRegion @Nullable [] calculateEditedLineRegions(final IDocument document, final IProgressMonitor monitor) {
        final IRegion[][] result = new IRegion[1][];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                LanguageServerPlugin.logError(exception.getLocalizedMessage(), exception);
                result[0] = null;
            }

            public void run() throws Exception {
                ITextFileBuffer buffer = LSPEclipseUtils.toBuffer(document);
                if (buffer == null) {
                    result[0] = null;
                    return;
                }
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Calculating changed regions", (int)4);
                IFileStore fileStore = buffer.getFileStore();
                ITextFileBufferManager fileBufferManager = FileBuffers.createTextFileBufferManager();
                fileBufferManager.connectFileStore(fileStore, (IProgressMonitor)progress.split(3));
                try {
                    IDocument currentDocument = buffer.getDocument();
                    IDocument oldDocument = ((ITextFileBuffer)fileBufferManager.getFileStoreFileBuffer(fileStore)).getDocument();
                    result[0] = this.getChangedLineRegions(oldDocument, currentDocument);
                }
                finally {
                    fileBufferManager.disconnectFileStore(fileStore, (IProgressMonitor)progress.split(1));
                }
            }

            private IRegion[] getChangedLineRegions(IDocument oldDocument, IDocument currentDocument) {
                DocLineComparator leftSide = new DocLineComparator(oldDocument, null, false);
                DocLineComparator rightSide = new DocLineComparator(currentDocument, null, false);
                RangeDifference[] differences = RangeDifferencer.findDifferences((IRangeComparator)leftSide, (IRangeComparator)rightSide);
                ArrayList<Object> regions = new ArrayList<Object>();
                int numberOfLines = currentDocument.getNumberOfLines();
                RangeDifference[] rangeDifferenceArray = differences;
                int n = differences.length;
                int n2 = 0;
                while (n2 < n) {
                    RangeDifference curr = rangeDifferenceArray[n2];
                    if (curr.kind() == 2) {
                        int startLine = Math.min(curr.rightStart(), numberOfLines - 1);
                        int endLine = curr.rightEnd() - 1;
                        try {
                            IRegion startLineRegion = currentDocument.getLineInformation(startLine);
                            if (startLine >= endLine) {
                                if (startLine == endLine || startLineRegion.getOffset() + startLineRegion.getLength() == currentDocument.getLength()) {
                                    regions.add(startLineRegion);
                                }
                            } else {
                                IRegion endLineRegion = currentDocument.getLineInformation(endLine);
                                int startOffset = startLineRegion.getOffset();
                                int endOffset = endLineRegion.getOffset() + endLineRegion.getLength();
                                regions.add(new Region(startOffset, endOffset - startOffset));
                            }
                        }
                        catch (BadLocationException e) {
                            LanguageServerPlugin.logError(e);
                        }
                    }
                    ++n2;
                }
                return (IRegion[])regions.toArray(IRegion[]::new);
            }
        });
        return result[0];
    }
}

