/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.catalog;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.ServiceLocator;
import org.eclipse.epp.internal.mpc.core.model.Identifiable;
import org.eclipse.epp.internal.mpc.core.model.Node;
import org.eclipse.epp.internal.mpc.core.model.SearchResult;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalogSource;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCategory;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceInfo;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeInstallableUnitItem;
import org.eclipse.epp.internal.mpc.ui.catalog.Messages;
import org.eclipse.epp.internal.mpc.ui.catalog.ResourceProvider;
import org.eclipse.epp.internal.mpc.ui.catalog.UserActionCatalogItem;
import org.eclipse.epp.mpc.core.model.ICategories;
import org.eclipse.epp.mpc.core.model.ICategory;
import org.eclipse.epp.mpc.core.model.IIdentifiable;
import org.eclipse.epp.mpc.core.model.IIu;
import org.eclipse.epp.mpc.core.model.IIus;
import org.eclipse.epp.mpc.core.model.IMarket;
import org.eclipse.epp.mpc.core.model.INews;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.core.model.ISearchResult;
import org.eclipse.epp.mpc.core.service.IMarketplaceService;
import org.eclipse.epp.mpc.core.service.QueryHelper;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.epp.mpc.ui.MarketplaceUrlHandler;
import org.eclipse.equinox.internal.p2.discovery.AbstractCatalogSource;
import org.eclipse.equinox.internal.p2.discovery.AbstractDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Icon;
import org.eclipse.equinox.internal.p2.discovery.model.Overview;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;

public class MarketplaceDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final Pattern BREAK_PATTERN = Pattern.compile("<!--\\s*break\\s*-->");
    protected final CatalogDescriptor catalogDescriptor;
    protected final IMarketplaceService marketplaceService;
    private MarketplaceCatalogSource source;
    private MarketplaceInfo marketplaceInfo;
    private Map<String, IInstallableUnit> featureIUById;
    private final String nodeContentUrlPrefix;

    public MarketplaceDiscoveryStrategy(CatalogDescriptor catalogDescriptor) {
        if (catalogDescriptor == null) {
            throw new IllegalArgumentException();
        }
        this.catalogDescriptor = catalogDescriptor;
        this.marketplaceService = this.createMarketplaceService();
        this.source = new MarketplaceCatalogSource(this.marketplaceService);
        this.marketplaceInfo = MarketplaceInfo.getInstance();
        this.nodeContentUrlPrefix = String.valueOf(this.marketplaceService.getBaseUrl()) + "/content/";
    }

    @Deprecated
    public IMarketplaceService createMarketplaceService() {
        return this.acquireMarketplaceService();
    }

    protected IMarketplaceService acquireMarketplaceService() {
        String baseUrl = this.catalogDescriptor.getUrl().toExternalForm();
        return ServiceLocator.getCompatibilityLocator().getMarketplaceService(baseUrl);
    }

    @Deprecated
    public static Map<String, String> computeDefaultRequestMetaParameters() {
        return ServiceLocator.computeDefaultRequestMetaParameters();
    }

    public void dispose() {
        if (this.source != null) {
            this.source.dispose();
            this.source = null;
        }
        if (this.marketplaceInfo != null) {
            final MarketplaceInfo fMarketplaceInfo = this.marketplaceInfo;
            new Job(Messages.MarketplaceDiscoveryStrategy_saveMarketplaceInfoJobName){
                {
                    super($anonymous0);
                    this.setSystem(true);
                    this.setPriority(20);
                    this.setUser(false);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        fMarketplaceInfo.save();
                    }
                    catch (Exception e) {
                        return MarketplaceClientCore.computeStatus((Throwable)e, (String)Messages.MarketplaceDiscoveryStrategy_failedToSaveMarketplaceInfo);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
            this.marketplaceInfo = null;
        }
        super.dispose();
    }

    public void performDiscovery(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarketplaceDiscoveryStrategy_loadingMarketplace, (int)3000);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)progress.newChild(1000));
            this.handleDiscoveryCategory(catalogCategory);
            ISearchResult discoveryResult = this.doPerformDiscovery((IProgressMonitor)progress.newChild(1000));
            this.handleSearchResult(catalogCategory, discoveryResult, (IProgressMonitor)progress.newChild(1000));
            this.maybeAddCatalogItem(catalogCategory);
        }
        finally {
            monitor.done();
        }
    }

    protected ISearchResult doPerformDiscovery(IProgressMonitor monitor) throws CoreException {
        return this.marketplaceService.featured(monitor);
    }

    protected void handleDiscoveryCategory(MarketplaceCategory catalogCategory) {
        catalogCategory.setContents(MarketplaceCategory.Contents.FEATURED);
    }

    protected void handleSearchResult(MarketplaceCategory catalogCategory, ISearchResult result, IProgressMonitor monitor) {
        List items = this.getItems();
        if (items != null && !result.getNodes().isEmpty()) {
            int nodeWork = 1000;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarketplaceDiscoveryStrategy_loadingResources, (int)(result.getNodes().size() * nodeWork));
            try {
                for (INode node : result.getNodes()) {
                    CatalogItem catalogItem = this.createCatalogItem(node, catalogCategory.getId(), (IProgressMonitor)progress.newChild(nodeWork));
                    items.add(catalogItem);
                }
            }
            finally {
                progress.done();
            }
            if (result.getMatchCount() != null) {
                catalogCategory.setMatchCount(result.getMatchCount());
                if (result.getMatchCount() > result.getNodes().size()) {
                    this.addCatalogItem(catalogCategory);
                }
            }
        }
    }

    protected CatalogItem createCatalogItem(INode node, String categoryId, IProgressMonitor monitor) {
        String id = node.getId();
        try {
            MarketplaceNodeCatalogItem catalogItem = new MarketplaceNodeCatalogItem();
            catalogItem.setMarketplaceUrl(this.catalogDescriptor.getUrl());
            catalogItem.setId(id);
            catalogItem.setName(MarketplaceDiscoveryStrategy.getCatalogItemName(node));
            catalogItem.setCategoryId(categoryId);
            ICategories categories = node.getCategories();
            if (categories != null) {
                for (ICategory category : categories.getCategory()) {
                    catalogItem.addTag(new Tag(ICategory.class, category.getId(), category.getName()));
                }
            }
            catalogItem.setData(node);
            catalogItem.setSource(this.source);
            catalogItem.setLicense(node.getLicense());
            IIus ius = node.getIus();
            if (ius != null) {
                ArrayList<MarketplaceNodeInstallableUnitItem> installableUnitItems = new ArrayList<MarketplaceNodeInstallableUnitItem>();
                for (IIu iu : ius.getIuElements()) {
                    MarketplaceNodeInstallableUnitItem iuItem = new MarketplaceNodeInstallableUnitItem();
                    iuItem.init(iu);
                    installableUnitItems.add(iuItem);
                }
                catalogItem.setInstallableUnitItems(installableUnitItems);
            }
            if (node.getShortdescription() == null && node.getBody() != null) {
                String shortDescriptionText;
                int start;
                String descriptionText = node.getBody();
                Matcher matcher = BREAK_PATTERN.matcher(node.getBody());
                if (matcher.find() && (start = matcher.start()) > 0 && (shortDescriptionText = descriptionText.substring(0, start).trim()).length() > 0) {
                    descriptionText = shortDescriptionText;
                }
                catalogItem.setDescription(descriptionText);
            } else {
                catalogItem.setDescription(node.getShortdescription());
            }
            String provider = node.getCompanyname();
            if (provider == null || provider.isEmpty()) {
                provider = node.getOwner();
            }
            catalogItem.setProvider(provider);
            String updateurl = node.getUpdateurl();
            if (updateurl != null) {
                try {
                    updateurl = updateurl.trim();
                    URLUtil.toURL((String)updateurl);
                    catalogItem.setSiteUrl(updateurl);
                }
                catch (MalformedURLException start) {
                    // empty catch block
                }
            }
            if (catalogItem.getInstallableUnits() == null || catalogItem.getInstallableUnits().isEmpty() || catalogItem.getSiteUrl() == null) {
                catalogItem.setAvailable(false);
            }
            if (node.getImage() != null) {
                if (!this.source.getResourceProvider().containsResource(node.getImage())) {
                    MarketplaceDiscoveryStrategy.cacheResource(this.source.getResourceProvider(), catalogItem, node.getImage());
                }
                MarketplaceDiscoveryStrategy.createIcon(catalogItem, node);
            }
            if (node.getBody() != null || node.getScreenshot() != null) {
                Overview overview = new Overview();
                overview.setItem((CatalogItem)catalogItem);
                overview.setSummary(node.getBody());
                overview.setUrl(node.getUrl());
                catalogItem.setOverview(overview);
                if (node.getScreenshot() != null) {
                    if (!this.source.getResourceProvider().containsResource(node.getScreenshot())) {
                        MarketplaceDiscoveryStrategy.cacheResource(this.source.getResourceProvider(), catalogItem, node.getScreenshot());
                    }
                    overview.setScreenshot(node.getScreenshot());
                }
            }
            this.marketplaceInfo.map(catalogItem.getMarketplaceUrl(), node);
            this.marketplaceInfo.computeInstalled(this.computeInstalledFeatures(monitor), catalogItem);
            return catalogItem;
        }
        catch (RuntimeException ex) {
            MarketplaceClientUi.error(NLS.bind((String)Messages.MarketplaceDiscoveryStrategy_ParseError, (Object)(node == null ? "null" : id)), ex);
            return null;
        }
    }

    public static void cacheResource(ResourceProvider resourceProvider, CatalogItem catalogItem, String resource) {
        if (!resourceProvider.containsResource(resource)) {
            String requestSource = NLS.bind((String)Messages.MarketplaceDiscoveryStrategy_requestSource, (Object)catalogItem.getName(), (Object)catalogItem.getId());
            try {
                resourceProvider.retrieveResource(requestSource, resource);
            }
            catch (URISyntaxException e) {
                MarketplaceClientUi.log(2, Messages.MarketplaceDiscoveryStrategy_badUri, catalogItem.getName(), catalogItem.getId(), resource, e);
            }
            catch (IOException e) {
                MarketplaceClientUi.log(2, Messages.MarketplaceDiscoveryStrategy_downloadError, catalogItem.getName(), catalogItem.getId(), resource, e);
            }
        }
    }

    private static String getCatalogItemName(INode node) {
        String name = node.getName();
        String version = node.getVersion();
        return version == null || version.length() == 0 ? name : NLS.bind((String)Messages.MarketplaceDiscoveryStrategy_Name_and_Version, (Object)name, (Object)version);
    }

    public void maybeAddCatalogItem(MarketplaceCategory catalogCategory) {
        CatalogItem catalogItem;
        List items = this.getItems();
        if (items != null && !items.isEmpty() && (catalogItem = (CatalogItem)items.get(items.size() - 1)).getData() != this.catalogDescriptor) {
            this.addCatalogItem(catalogCategory);
        }
    }

    public void addCatalogItem(MarketplaceCategory catalogCategory) {
        CatalogItem catalogItem = this.createCategoryItem(catalogCategory);
        this.items.add(catalogItem);
    }

    private CatalogItem createCategoryItem(MarketplaceCategory catalogCategory) {
        CatalogItem catalogItem = new CatalogItem();
        catalogItem.setSource((AbstractCatalogSource)this.source);
        catalogItem.setData((Object)this.catalogDescriptor);
        catalogItem.setId(this.catalogDescriptor.getUrl().toString());
        catalogItem.setCategoryId(catalogCategory.getId());
        return catalogItem;
    }

    public UserActionCatalogItem addUserActionItem(MarketplaceCategory catalogCategory, UserActionCatalogItem.UserAction userAction) {
        return this.addUserActionItem(catalogCategory, userAction, this.catalogDescriptor);
    }

    public UserActionCatalogItem addUserActionItem(MarketplaceCategory catalogCategory, UserActionCatalogItem.UserAction userAction, Object data) {
        ListIterator i = this.items.listIterator(this.items.size());
        while (i.hasPrevious()) {
            UserActionCatalogItem actionItem;
            CatalogItem item = (CatalogItem)i.previous();
            if (item.getSource() != this.source || item.getCategory() != catalogCategory && !catalogCategory.getId().equals(item.getCategoryId()) || !(item instanceof UserActionCatalogItem) || (actionItem = (UserActionCatalogItem)item).getUserAction() != userAction) continue;
            return actionItem;
        }
        UserActionCatalogItem catalogItem = new UserActionCatalogItem();
        catalogItem.setUserAction(userAction);
        catalogItem.setSource(this.source);
        catalogItem.setData(data);
        catalogItem.setId(this.catalogDescriptor.getUrl().toString() + "#" + userAction.name());
        catalogItem.setCategoryId(catalogCategory.getId());
        this.items.add(0, catalogItem);
        return catalogItem;
    }

    private static void createIcon(CatalogItem catalogItem, INode node) {
        Icon icon = new Icon();
        icon.setImage32(node.getImage());
        icon.setImage48(node.getImage());
        icon.setImage64(node.getImage());
        icon.setImage128(node.getImage());
        catalogItem.setIcon(icon);
    }

    public void tagged(String tag, IProgressMonitor monitor) throws CoreException {
        int totalWork = 1000;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarketplaceDiscoveryStrategy_searchingMarketplace, (int)1000);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)progress.newChild(1));
            catalogCategory.setContents(MarketplaceCategory.Contents.QUERY);
            ISearchResult result = this.marketplaceService.tagged(tag, (IProgressMonitor)progress.newChild(500));
            this.handleSearchResult(catalogCategory, result, (IProgressMonitor)progress.newChild(500));
            if (result.getNodes().isEmpty()) {
                catalogCategory.setMatchCount(0);
                this.addCatalogItem(catalogCategory);
            }
        }
        finally {
            progress.done();
        }
    }

    public void performQuery(IMarket market, ICategory category, String queryText, IProgressMonitor monitor) throws CoreException {
        int totalWork = 1001;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarketplaceDiscoveryStrategy_searchingMarketplace, (int)1001);
        try {
            ISearchResult result;
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)progress.newChild(1));
            catalogCategory.setContents(MarketplaceCategory.Contents.QUERY);
            SubMonitor nodeQueryProgress = progress.newChild(500);
            try {
                result = this.performNodeQuery(queryText, (IProgressMonitor)nodeQueryProgress);
            }
            catch (CoreException ex) {
                result = null;
                nodeQueryProgress.setWorkRemaining(0);
            }
            if (result == null) {
                ICategory resolvedCategory;
                IMarket resolvedMarket;
                try {
                    resolvedMarket = MarketplaceDiscoveryStrategy.resolve(market, catalogCategory.getMarkets());
                    resolvedCategory = MarketplaceDiscoveryStrategy.resolveCategory(category, catalogCategory.getMarkets());
                }
                catch (IllegalArgumentException ex) {
                    throw new CoreException(MarketplaceClientCore.computeStatus((Throwable)ex, (String)Messages.MarketplaceDiscoveryStrategy_invalidFilter));
                }
                catch (NoSuchElementException ex) {
                    throw new CoreException(MarketplaceClientCore.computeStatus((Throwable)ex, (String)Messages.MarketplaceDiscoveryStrategy_unknownFilter));
                }
                progress.setWorkRemaining(1000);
                result = this.marketplaceService.search(resolvedMarket, resolvedCategory, queryText, (IProgressMonitor)progress.newChild(500));
            }
            this.handleSearchResult(catalogCategory, result, (IProgressMonitor)progress.newChild(500));
            if (result.getNodes().isEmpty()) {
                catalogCategory.setMatchCount(0);
                this.addCatalogItem(catalogCategory);
            }
        }
        finally {
            progress.done();
        }
    }

    private static ICategory resolveCategory(ICategory category, List<? extends IMarket> markets) throws IllegalArgumentException, NoSuchElementException {
        if (category != null && category.getId() == null) {
            if (category.getUrl() == null && category.getName() == null) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.MarketplaceDiscoveryStrategy_unidentifiableItem, (Object)category));
            }
            for (IMarket iMarket : markets) {
                List categories = iMarket.getCategory();
                ICategory resolved = MarketplaceDiscoveryStrategy.resolve(category, categories);
                if (resolved == null) continue;
                return resolved;
            }
            if (category.getUrl() != null) {
                throw new NoSuchElementException(NLS.bind((String)Messages.MarketplaceDiscoveryStrategy_noUrlMatch, (Object)category.getUrl()));
            }
            throw new NoSuchElementException(NLS.bind((String)Messages.MarketplaceDiscoveryStrategy_noNameMatch, (Object)category.getName()));
        }
        return category;
    }

    private static <T extends IIdentifiable> T resolve(T id, List<? extends T> candidates) throws IllegalArgumentException, NoSuchElementException {
        if (id != null && id.getId() == null) {
            if (id.getUrl() == null && id.getName() == null) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.MarketplaceDiscoveryStrategy_unidentifiableItem, id));
            }
            for (IIdentifiable candidate : candidates) {
                if (!Identifiable.matches((IIdentifiable)candidate, id)) continue;
                return (T)candidate;
            }
            if (id.getUrl() != null) {
                throw new NoSuchElementException(NLS.bind((String)Messages.MarketplaceDiscoveryStrategy_noUrlMatch, (Object)id.getUrl()));
            }
            throw new NoSuchElementException(NLS.bind((String)Messages.MarketplaceDiscoveryStrategy_noNameMatch, (Object)id.getName()));
        }
        return id;
    }

    private ISearchResult performNodeQuery(String nodeUrl, IProgressMonitor progress) throws CoreException {
        final INode[] queryNode = new INode[1];
        MarketplaceUrlHandler urlHandler = new MarketplaceUrlHandler(){

            @Override
            protected boolean handleNode(CatalogDescriptor descriptor, String url, INode node) {
                queryNode[0] = node;
                return true;
            }
        };
        if (urlHandler.handleUri(nodeUrl) && queryNode[0] != null) {
            INode node = this.marketplaceService.getNode(queryNode[0], progress);
            SearchResult result = new SearchResult();
            result.setMatchCount(Integer.valueOf(1));
            result.setNodes(Collections.singletonList((Node)node));
            return result;
        }
        return null;
    }

    public void recent(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarketplaceDiscoveryStrategy_searchingMarketplace, (int)1001);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)progress.newChild(1));
            catalogCategory.setContents(MarketplaceCategory.Contents.RECENT);
            ISearchResult result = this.marketplaceService.recent((IProgressMonitor)progress.newChild(500));
            this.handleSearchResult(catalogCategory, result, (IProgressMonitor)progress.newChild(500));
            this.maybeAddCatalogItem(catalogCategory);
        }
        finally {
            monitor.done();
        }
    }

    public void related(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarketplaceDiscoveryStrategy_searchingMarketplace, (int)801);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)progress.newChild(1));
            catalogCategory.setContents(MarketplaceCategory.Contents.RELATED);
            SearchResult installed = this.computeInstalled((IProgressMonitor)progress.newChild(200));
            if (!monitor.isCanceled()) {
                ISearchResult result = this.marketplaceService.related(installed.getNodes(), (IProgressMonitor)progress.newChild(300));
                this.handleSearchResult(catalogCategory, result, (IProgressMonitor)progress.newChild(300));
                this.maybeAddCatalogItem(catalogCategory);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void featured(IProgressMonitor monitor, IMarket market, ICategory category) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarketplaceDiscoveryStrategy_searchingMarketplace, (int)1001);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)progress.newChild(1));
            catalogCategory.setContents(MarketplaceCategory.Contents.FEATURED);
            ISearchResult result = this.marketplaceService.featured(market, category, (IProgressMonitor)progress.newChild(500));
            this.handleSearchResult(catalogCategory, result, (IProgressMonitor)progress.newChild(500));
            this.maybeAddCatalogItem(catalogCategory);
        }
        finally {
            monitor.done();
        }
    }

    public void popular(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarketplaceDiscoveryStrategy_searchingMarketplace, (int)1001);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)progress.newChild(1));
            catalogCategory.setContents(MarketplaceCategory.Contents.POPULAR);
            ISearchResult result = this.marketplaceService.popular((IProgressMonitor)progress.newChild(500));
            this.handleSearchResult(catalogCategory, result, (IProgressMonitor)progress.newChild(500));
            this.maybeAddCatalogItem(catalogCategory);
        }
        finally {
            monitor.done();
        }
    }

    public void addUpdateItem(MarketplaceCategory catalogCategory, List<MarketplaceNodeCatalogItem> availableUpdates) {
        this.addUserActionItem(catalogCategory, UserActionCatalogItem.UserAction.UPDATE, availableUpdates);
    }

    public void installed(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarketplaceDiscoveryStrategy_findingInstalled, (int)1000);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)progress.newChild(1));
            catalogCategory.setContents(MarketplaceCategory.Contents.INSTALLED);
            SearchResult result = this.computeInstalled((IProgressMonitor)progress.newChild(500));
            if (!monitor.isCanceled()) {
                this.handleSearchResult(catalogCategory, (ISearchResult)result, (IProgressMonitor)progress.newChild(500));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected SearchResult computeInstalled(IProgressMonitor monitor) throws CoreException {
        SearchResult result = new SearchResult();
        result.setNodes(new ArrayList());
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarketplaceDiscoveryStrategy_ComputingInstalled, (int)1000);
        Map<String, IInstallableUnit> installedIUs = this.computeInstalledIUs((IProgressMonitor)progress.newChild(500));
        if (!monitor.isCanceled()) {
            Set<INode> catalogNodes = this.marketplaceInfo.computeInstalledNodes(this.catalogDescriptor.getUrl(), installedIUs);
            if (!catalogNodes.isEmpty()) {
                List resolvedNodes = this.marketplaceService.getNodes(catalogNodes, (IProgressMonitor)progress.newChild(490));
                HashMap<String, INode> uniqueNodes = new HashMap<String, INode>();
                SubMonitor nodeProgress = SubMonitor.convert((IProgressMonitor)progress.newChild(10), (int)resolvedNodes.size());
                for (INode node : resolvedNodes) {
                    boolean duplicate = node.getId() != null && uniqueNodes.put(node.getId(), node) != null;
                    boolean bl = duplicate = node.getUrl() != null && uniqueNodes.put(node.getUrl(), node) != null || duplicate;
                    if (!duplicate && this.marketplaceInfo.computeInstalled(installedIUs.keySet(), node)) {
                        result.getNodes().add((Node)node);
                    }
                    nodeProgress.worked(1);
                }
            } else {
                monitor.worked(500);
            }
        }
        return result;
    }

    public void performQuery(IProgressMonitor monitor, Set<String> nodeIds) throws CoreException {
        Set nodes = nodeIds.stream().map(id -> QueryHelper.nodeByIdAndUrl((String)id, (String)(this.nodeContentUrlPrefix + id))).collect(Collectors.toSet());
        this.performNodeQuery(monitor, nodes);
    }

    public void performNodeQuery(IProgressMonitor monitor, Set<? extends INode> nodes) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarketplaceDiscoveryStrategy_searchingMarketplace, (int)1001);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)progress.newChild(1));
            catalogCategory.setContents(MarketplaceCategory.Contents.QUERY);
            SearchResult result = new SearchResult();
            result.setNodes(new ArrayList());
            if (!monitor.isCanceled()) {
                if (!nodes.isEmpty()) {
                    List resolvedNodes = this.marketplaceService.getNodes(nodes, (IProgressMonitor)progress.newChild(500));
                    for (INode node : resolvedNodes) {
                        result.getNodes().add((Node)node);
                    }
                } else {
                    progress.setWorkRemaining(500);
                }
                result.setMatchCount(Integer.valueOf(result.getNodes().size()));
                this.handleSearchResult(catalogCategory, (ISearchResult)result, (IProgressMonitor)progress.newChild(500));
            }
        }
        finally {
            monitor.done();
        }
    }

    @Deprecated
    protected Set<String> computeInstalledFeatures(IProgressMonitor monitor) {
        return this.computeInstalledIUs(monitor).keySet();
    }

    protected synchronized Map<String, IInstallableUnit> computeInstalledIUs(IProgressMonitor monitor) {
        if (this.featureIUById == null) {
            this.featureIUById = MarketplaceClientUi.computeInstalledIUsById(monitor);
        }
        return this.featureIUById;
    }

    protected MarketplaceCategory findMarketplaceCategory(IProgressMonitor monitor) throws CoreException {
        MarketplaceCategory catalogCategory = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarketplaceDiscoveryStrategy_catalogCategory, (int)10000);
        try {
            ArrayList<MarketplaceCategory> categories = this.getCategories();
            if (categories == null) {
                categories = new ArrayList<MarketplaceCategory>();
                this.setCategories(categories);
            }
            for (CatalogCategory catalogCategory2 : categories) {
                if (catalogCategory2.getSource() != this.source) continue;
                catalogCategory = (MarketplaceCategory)catalogCategory2;
            }
            if (catalogCategory == null) {
                List list = this.marketplaceService.listMarkets((IProgressMonitor)progress.newChild(10000));
                catalogCategory = new MarketplaceCategory();
                catalogCategory.setId("<root>");
                catalogCategory.setName("<root>");
                catalogCategory.setSource(this.source);
                catalogCategory.setMarkets(list);
                categories.add(catalogCategory);
            }
        }
        finally {
            progress.done();
        }
        return catalogCategory;
    }

    public INews performNewsDiscovery(IProgressMonitor monitor) throws CoreException {
        return this.marketplaceService.news(monitor);
    }

    public void installErrorReport(IProgressMonitor monitor, IStatus result, Set<CatalogItem> items, IInstallableUnit[] operationIUs, String resolutionDetails) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarketplaceDiscoveryStrategy_sendingErrorNotification, (int)100);
        try {
            HashSet<Node> nodes = new HashSet<Node>();
            for (CatalogItem item : items) {
                Object data = item.getData();
                if (!(data instanceof INode)) continue;
                nodes.add((Node)data);
            }
            HashSet<CallSite> iuIdsAndVersions = new HashSet<CallSite>();
            IInstallableUnit[] iInstallableUnitArray = operationIUs;
            int n = operationIUs.length;
            int n2 = 0;
            while (n2 < n) {
                IInstallableUnit iu = iInstallableUnitArray[n2];
                String id = iu.getId();
                String version = iu.getVersion() == null ? null : iu.getVersion().toString();
                iuIdsAndVersions.add((CallSite)((Object)(id + "," + version)));
                ++n2;
            }
            this.marketplaceService.reportInstallError(result, nodes, iuIdsAndVersions, resolutionDetails, (IProgressMonitor)progress);
        }
        finally {
            progress.done();
        }
    }

    public IMarketplaceService getMarketplaceService() {
        return this.marketplaceService;
    }

    protected MarketplaceCatalogSource getCatalogSource() {
        return this.source;
    }
}

