/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.convert;

import com.overzealous.remark.Options;
import com.overzealous.remark.convert.AbstractNodeHandler;
import com.overzealous.remark.convert.DocumentConverter;
import com.overzealous.remark.convert.NodeHandler;
import com.overzealous.remark.util.MarkdownTable;
import com.overzealous.remark.util.MarkdownTableCell;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Element;

public class Table
extends AbstractNodeHandler {
    private static final Pattern STYLE_ALIGNMENT_PATTERN = Pattern.compile("text-align:\\s*([a-z]+)", 2);

    @Override
    public void handleNode(NodeHandler parent, Element node, DocumentConverter converter) {
        MarkdownTable table = new MarkdownTable();
        for (Element child : node.children()) {
            if (child.tagName().equals("thead")) {
                for (Element headerRow : child.children()) {
                    this.processRow(table.addHeaderRow(), headerRow, converter);
                }
                continue;
            }
            if (child.tagName().equals("tbody") || child.tagName().equals("tfoot")) {
                for (Element bodyRow : child.children()) {
                    this.processRow(table.addBodyRow(), bodyRow, converter);
                }
                continue;
            }
            if (!child.tagName().equals("tr") || child.children().isEmpty()) continue;
            if (((Element)child.children().get(0)).tagName().equals("th")) {
                this.processRow(table.addHeaderRow(), child, converter);
                continue;
            }
            this.processRow(table.addBodyRow(), child, converter);
        }
        Options.Tables opts = converter.options.getTables();
        converter.output.startBlock();
        table.renderTable(converter.output, opts.isColspanEnabled(), opts.isRenderedAsCode());
        converter.output.endBlock();
    }

    private void processRow(List<MarkdownTableCell> row, Element tableRow, DocumentConverter converter) {
        for (Element cell : tableRow.children()) {
            String contents = converter.getInlineContent(this, cell, true);
            row.add(new MarkdownTableCell(contents, this.getAlignment(cell), this.getColspan(cell)));
        }
    }

    private MarkdownTable.Alignment getAlignment(Element cell) {
        Matcher m;
        MarkdownTable.Alignment alignment = MarkdownTable.Alignment.LEFT;
        String alignmentString = null;
        if (cell.hasAttr("align")) {
            alignmentString = cell.attr("align").toLowerCase();
        } else if (cell.hasAttr("style") && (m = STYLE_ALIGNMENT_PATTERN.matcher(cell.attr("style"))).find()) {
            alignmentString = m.group(1).toLowerCase();
        }
        if (alignmentString != null) {
            if (alignmentString.equals("center")) {
                alignment = MarkdownTable.Alignment.CENTER;
            } else if (alignmentString.equals("right")) {
                alignment = MarkdownTable.Alignment.RIGHT;
            }
        }
        return alignment;
    }

    private int getColspan(Element cell) {
        int colspan = 1;
        if (cell.hasAttr("colspan")) {
            try {
                colspan = Integer.parseInt(cell.attr("colspan"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return colspan;
    }
}

