/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.convert;

import com.overzealous.remark.Options;
import com.overzealous.remark.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class TextCleaner {
    private Map<String, String> replacements;
    private Pattern entityReplacementsPattern;
    private Pattern unicodeReplacementsPattern = null;
    private List<Escape> escapes;
    private Pattern unescapeLeadingChars;
    private static final Pattern EMPTY_MATCHER = Pattern.compile("\\s+", 32);
    private static final Pattern LINEBREAK_REMOVER = Pattern.compile("(\\s*\\r?+\\n)+");
    private static final Pattern URL_CLEANER = Pattern.compile("([\\(\\) ])");

    public TextCleaner(Options options) {
        this.setupReplacements(options);
        this.setupEscapes(options);
    }

    private void setupReplacements(Options options) {
        this.replacements = new HashMap<String, String>();
        StringBuilder entities = new StringBuilder(this.replacements.size() * 5);
        entities.append("&(?>amp;([#a-z0-9]++;)|(?>");
        this.addRepl(entities, "&amp;", "&");
        this.addRepl(entities, "&lt;", "<");
        this.addRepl(entities, "&gt;", ">");
        this.addRepl(entities, "&quot;", "\"");
        if (options.reverseHtmlSmartQuotes) {
            this.addRepl(entities, "&ldquo;", "\"");
            this.addRepl(entities, "&rdquo;", "\"");
            this.addRepl(entities, "&lsquo;", "'");
            this.addRepl(entities, "&rsquo;", "'");
            this.addRepl(entities, "&apos;", "'");
            this.addRepl(entities, "&laquo;", "<<");
            this.addRepl(entities, "&raquo;", ">>");
        }
        if (options.reverseHtmlSmartPunctuation) {
            this.addRepl(entities, "&ndash;", "--");
            this.addRepl(entities, "&mdash;", "---");
            this.addRepl(entities, "&hellip;", "...");
        }
        entities.replace(entities.length() - 1, entities.length(), ");)");
        this.entityReplacementsPattern = Pattern.compile(entities.toString(), 2);
        if (options.reverseUnicodeSmartPunctuation || options.reverseUnicodeSmartQuotes) {
            StringBuilder unicode = new StringBuilder("[\\Q");
            if (options.reverseUnicodeSmartQuotes) {
                this.addRepl(unicode, "\u201c", "\"");
                this.addRepl(unicode, "\u201d", "\"");
                this.addRepl(unicode, "\u2018", "'");
                this.addRepl(unicode, "\u2019", "'");
                this.addRepl(unicode, "\u00ab", "<<");
                this.addRepl(unicode, "\u00bb", ">>");
            }
            if (options.reverseUnicodeSmartPunctuation) {
                this.addRepl(unicode, "\u2013", "--");
                this.addRepl(unicode, "\u2014", "---");
                this.addRepl(unicode, "\u2026", "...");
            }
            unicode.append("\\E]");
            this.unicodeReplacementsPattern = Pattern.compile(unicode.toString());
        }
    }

    private void addRepl(StringBuilder regex, String original, String replacement) {
        this.replacements.put(original, replacement);
        if (original.charAt(0) == '&') {
            regex.append(original.substring(1, original.length() - 1));
            regex.append('|');
        } else {
            regex.append(original);
        }
    }

    private void setupEscapes(Options options) {
        this.escapes = new ArrayList<Escape>();
        this.escapes.add(new Escape("\\\\", "\\\\\\\\"));
        StringBuilder chars = new StringBuilder("([\\Q`*_{}[]#");
        if (options.tables.isConvertedToText() && !options.tables.isRenderedAsCode()) {
            chars.append('|');
        }
        chars.append("\\E])");
        this.escapes.add(new Escape(chars.toString(), "\\\\$1"));
        StringBuilder leadingChars = new StringBuilder("^( ?+)([\\Q-+");
        if (options.definitionLists) {
            leadingChars.append(':');
        }
        leadingChars.append("\\E])");
        this.escapes.add(new Escape(leadingChars.toString(), "$1\\\\$2"));
        this.unescapeLeadingChars = Pattern.compile(leadingChars.insert(6, "\\\\").toString());
    }

    public String clean(Object input) {
        return this.clean(input, true);
    }

    public String cleanCode(Object input) {
        return this.clean(input, false);
    }

    private String clean(Object oinput, boolean normalText) {
        String result;
        String input = oinput instanceof TextNode ? this.getTextNodeText((TextNode)oinput, normalText) : (oinput instanceof Element ? (normalText ? ((Element)oinput).text() : this.getPreformattedText((Element)oinput)) : oinput.toString());
        if (input.length() == 0) {
            result = "";
        } else if (normalText) {
            input = LINEBREAK_REMOVER.matcher(input).replaceAll(" ");
            for (Escape rep : this.escapes) {
                input = rep.pattern.matcher(input).replaceAll(rep.replacement);
            }
            StringBuffer output = this.doReplacements(input, this.entityReplacementsPattern);
            if (this.unicodeReplacementsPattern != null) {
                output = this.doReplacements(output, this.unicodeReplacementsPattern);
            }
            result = output.toString();
        } else {
            result = StringEscapeUtils.unescapeHtml4(input.replace("&apos;", "'"));
        }
        return result;
    }

    private String getPreformattedText(Element oinput) {
        Element el = oinput.clone();
        this.fixLineBreaks(el);
        return el.text();
    }

    private void fixLineBreaks(Element el) {
        for (Element e : el.children()) {
            if (e.tagName().equals("br")) {
                e.before("\n");
                e.remove();
                continue;
            }
            this.fixLineBreaks(e);
        }
    }

    private StringBuffer doReplacements(CharSequence input, Pattern regex) {
        StringBuffer output = new StringBuffer();
        Matcher m = regex.matcher(input);
        while (m.find()) {
            String replacementKey = m.group().toLowerCase(Locale.ENGLISH);
            String repString = this.replacements.containsKey(replacementKey) ? this.replacements.get(replacementKey) : "\\\\&$1";
            m.appendReplacement(output, repString);
        }
        m.appendTail(output);
        return output;
    }

    public String cleanInlineCode(Object input) {
        String output = this.clean(input, false).replace('\n', ' ');
        if (output.indexOf(96) != -1) {
            String prepend = "";
            if (output.charAt(0) == '`') {
                prepend = " ";
            }
            String append = "";
            if (output.charAt(output.length() - 1) == '`') {
                append = " ";
            }
            String delim = this.getDelimiter(output);
            output = String.format("%s%s%s%s%s", delim, prepend, output, append, delim);
        } else {
            output = String.format("`%s`", output);
        }
        return output;
    }

    public String unescapeLeadingCharacters(String input) {
        return this.unescapeLeadingChars.matcher(input).replaceAll("$1$2");
    }

    public String cleanUrl(String input) {
        StringBuffer output = new StringBuffer();
        Matcher m = URL_CLEANER.matcher(input);
        while (m.find()) {
            char c = m.group().charAt(0);
            m.appendReplacement(output, String.format("%%%02x", c));
        }
        m.appendTail(output);
        return output.toString();
    }

    String getDelimiter(String input) {
        int max = 0;
        int counter = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '`') {
                ++counter;
                continue;
            }
            max = Math.max(max, counter);
            counter = 0;
        }
        max = Math.max(max, counter);
        return StringUtils.multiply('`', max + 1);
    }

    private String getTextNodeText(TextNode tn, boolean normalText) {
        TextNode tprev;
        String input = normalText ? tn.text() : tn.getWholeText();
        Node prev = tn.previousSibling();
        Node next = tn.nextSibling();
        boolean parentIsBlock = this.isBlock(tn.parent());
        if (this.isBlock(prev)) {
            input = this.ltrim(input);
        } else if (prev == null && parentIsBlock) {
            input = this.ltrim(input);
        } else if (normalText && prev instanceof TextNode && EMPTY_MATCHER.matcher((tprev = (TextNode)prev).text()).matches()) {
            input = this.ltrim(input);
        }
        if (input.length() > 0) {
            TextNode tnext;
            if (this.isBlock(next)) {
                input = this.rtrim(input);
            } else if (next == null && parentIsBlock) {
                input = this.rtrim(input);
            } else if (normalText && next instanceof TextNode && EMPTY_MATCHER.matcher((tnext = (TextNode)next).text()).matches()) {
                input = this.rtrim(input);
            }
        }
        return input;
    }

    private boolean isBlock(Node n) {
        boolean block = false;
        if (n != null && n instanceof Element) {
            Element el = (Element)n;
            block = el.isBlock() || el.tagName().equals("br");
        }
        return block;
    }

    private String ltrim(String s) {
        int start = 0;
        while (start + 1 <= s.length() && EMPTY_MATCHER.matcher(s.substring(start, start + 1)).matches()) {
            ++start;
        }
        String ret = "";
        if (start != s.length()) {
            ret = s.substring(start);
        }
        return ret;
    }

    private String rtrim(String s) {
        int end = s.length();
        while (end - 1 >= 0 && EMPTY_MATCHER.matcher(s.substring(end - 1, end)).matches()) {
            --end;
        }
        String ret = "";
        if (end != 0) {
            ret = s.substring(0, end);
        }
        return ret;
    }

    private class Escape {
        final Pattern pattern;
        final String replacement;

        public Escape(String pattern, String replacement) {
            this.pattern = Pattern.compile(pattern);
            this.replacement = replacement;
        }
    }
}

