/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.dtd.participants.diagnostics;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPErrorReporterForXML;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.extensions.dtd.participants.diagnostics.LSPXML11DTDProcessor;
import org.eclipse.lemminx.extensions.xerces.LSPSecurityManager;
import org.eclipse.lemminx.extensions.xerces.LSPXMLEntityManager;
import org.eclipse.lemminx.extensions.xerces.ReferencedGrammarDiagnosticsInfo;
import org.eclipse.lemminx.uriresolver.CacheResourceException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class DTDValidator {
    private static final Logger LOGGER = Logger.getLogger(DTDValidator.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doDiagnostics(DOMDocument document, XMLEntityResolver entityResolver, List<Diagnostic> diagnostics, XMLValidationSettings validationSettings, ContentModelManager contentModelManager, CancelChecker monitor) {
        LSPErrorReporterForXML reporterForXML = new LSPErrorReporterForXML(document, diagnostics, contentModelManager, false, new HashMap<String, ReferencedGrammarDiagnosticsInfo>());
        try {
            LSPXMLEntityManager entityManager = DTDValidator.createXMLEntityManager(reporterForXML, entityResolver, validationSettings);
            LSPXML11DTDProcessor loader = new LSPXML11DTDProcessor(entityManager, reporterForXML, entityResolver);
            String content = document.getText();
            String uri = document.getDocumentURI();
            StringReader inputStream = new StringReader(content);
            XMLInputSource source = new XMLInputSource(null, uri, uri, inputStream, null);
            loader.loadGrammar(source);
        }
        catch (IOException | CancellationException entityManager) {
        }
        catch (CacheResourceException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unexpected DTDValidator error", e);
        }
        finally {
            reporterForXML.endReport();
        }
    }

    private static LSPXMLEntityManager createXMLEntityManager(LSPErrorReporterForXML reporterForXML, XMLEntityResolver entityResolver, XMLValidationSettings validationSettings) {
        LSPXMLEntityManager entityManager = new LSPXMLEntityManager(reporterForXML, null);
        boolean resolveExternalEntities = validationSettings != null ? validationSettings.isResolveExternalEntities() : false;
        entityManager.setResolveExternalEntities(resolveExternalEntities);
        entityManager.setEntityResolver(entityResolver);
        entityManager.setSecurityManager(LSPSecurityManager.getSecurityManager());
        return entityManager;
    }
}

