/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.extensions.completion;

import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.extensions.completion.AbstractCompletionResolver;
import org.eclipse.lemminx.services.extensions.completion.AbstractElementCompletionItem;
import org.eclipse.lemminx.services.extensions.completion.ICompletionItemResolverRequest;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class ElementEndTagCompletionResolver
extends AbstractCompletionResolver {
    public static final String PARTICIPANT_ID = ElementEndTagCompletionResolver.class.getName();

    @Override
    protected void resolveCompletionItem(DOMNode node, CompletionItem toResolve, ICompletionItemResolverRequest request, CancelChecker cancelChecker) {
        ElementEndTagCompletionResolver.resolveEndTagNameTextEdit(node, request, toResolve);
    }

    private static void resolveEndTagNameTextEdit(DOMNode node, ICompletionItemResolverRequest request, CompletionItem toResolve) {
        if (request.isResolveAdditionalTextEditsSupported()) {
            Boolean updateEndTagName = request.getDataPropertyAsBoolean("updateEndTagName");
            if (updateEndTagName == null || !updateEndTagName.booleanValue()) {
                return;
            }
            String tagName = toResolve.getLabel();
            AbstractElementCompletionItem.updateEndTagName(node, request.getCompletionOffset(), request, tagName, toResolve);
        }
    }
}

