/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.settings;

import java.util.Arrays;
import org.eclipse.lemminx.settings.XMLExcludedSymbolFile;
import org.eclipse.lemminx.settings.XMLSymbolFilter;

public class XMLSymbolSettings {
    private static final int DEFAULT_MAX_ITEMS_COMPUTED = 5000;
    private transient XMLExcludedSymbolFile[] excludedFiles;
    private XMLSymbolFilter[] filters;
    private boolean enabled = true;
    private String[] excluded;
    private int maxItemsComputed = 5000;

    public XMLExcludedSymbolFile[] getExcludedFiles() {
        return this.excludedFiles;
    }

    public void setFilters(XMLSymbolFilter[] filters) {
        this.filters = filters;
    }

    public XMLSymbolFilter[] getFilters() {
        return this.filters;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String[] getExcluded() {
        return this.excluded;
    }

    public void setExcluded(String[] excluded) {
        XMLExcludedSymbolFile[] exclusions = new XMLExcludedSymbolFile[excluded.length];
        for (int i = 0; i < excluded.length; ++i) {
            exclusions[i] = new XMLExcludedSymbolFile(excluded[i]);
        }
        this.excludedFiles = exclusions;
    }

    public boolean isExcluded(String uri) {
        if (this.excludedFiles == null) {
            return false;
        }
        for (XMLExcludedSymbolFile excludedFile : this.excludedFiles) {
            if (!excludedFile.matches(uri)) continue;
            return true;
        }
        return false;
    }

    public int getMaxItemsComputed() {
        return this.maxItemsComputed;
    }

    public void setMaxItemsComputed(int maxItemsComputed) {
        this.maxItemsComputed = maxItemsComputed;
    }

    public void merge(XMLSymbolSettings newSettings) {
        XMLSymbolFilter[] newFilters;
        this.setEnabled(newSettings.isEnabled());
        String[] newPatterns = newSettings.getExcluded();
        if (newPatterns != null) {
            String[] newPatternsCopy = Arrays.copyOf(newPatterns, newPatterns.length);
            this.setExcluded(newPatternsCopy);
        }
        if ((newFilters = newSettings.getFilters()) != null) {
            XMLSymbolFilter[] newFiltersCopy = Arrays.copyOf(newFilters, newFilters.length);
            this.setFilters(newFiltersCopy);
        }
        this.setMaxItemsComputed(newSettings.getMaxItemsComputed());
    }

    public XMLSymbolFilter getFilterFor(String uri) {
        if (this.filters != null) {
            for (XMLSymbolFilter filter : this.filters) {
                if (!filter.matches(uri)) continue;
                return filter;
            }
        }
        return XMLSymbolFilter.DEFAULT;
    }
}

