/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.uriresolver;

import java.text.MessageFormat;
import org.eclipse.lemminx.uriresolver.CacheResourceException;

public class InvalidURIException
extends CacheResourceException {
    private static final long serialVersionUID = 1L;
    private final InvalidURIError errorCode;

    public InvalidURIException(String resourceURI, InvalidURIError errorCode, Throwable cause) {
        super(resourceURI, errorCode.getMessage(resourceURI, cause.getMessage()));
        this.errorCode = errorCode;
    }

    public InvalidURIException(String resourceURI, InvalidURIError errorCode, String ... arguments) {
        super(resourceURI, errorCode.getMessage(InvalidURIException.combine(resourceURI, arguments)));
        this.errorCode = errorCode;
    }

    private static Object[] combine(String resourceURI, String[] arguments) {
        if (arguments == null || arguments.length == 0) {
            return new Object[]{resourceURI};
        }
        Object[] newArr = new String[arguments.length + 1];
        System.arraycopy(arguments, 0, newArr, 1, arguments.length);
        newArr[0] = resourceURI;
        return newArr;
    }

    public InvalidURIError getErrorCode() {
        return this.errorCode;
    }

    public static enum InvalidURIError {
        ILLEGAL_SYNTAX("The ''{0}'' URI cannot be parsed: {1}"),
        INVALID_PATH("''{0}'' does not resolve to a valid URI."),
        UNSUPPORTED_PROTOCOL("Unsupported ''{1}'' protocol in ''{0}''"),
        INSECURE_REDIRECTION("Redirection from ''{0}'' to insecure ''{1}'' is forbidden");

        private final String rawMessage;

        private InvalidURIError(String rawMessage) {
            this.rawMessage = rawMessage;
        }

        public String getMessage(Object ... arguments) {
            return MessageFormat.format(this.rawMessage, arguments);
        }
    }
}

