/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.adapters;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;

public class VersionedTextDocumentIdentifierTypeAdapter
extends TypeAdapter<VersionedTextDocumentIdentifier> {
    private final Gson gson;

    protected void writeVersion(JsonWriter out, Integer value) throws IOException {
        if (value == null) {
            boolean previousSerializeNulls = out.getSerializeNulls();
            out.setSerializeNulls(true);
            out.nullValue();
            out.setSerializeNulls(previousSerializeNulls);
        } else {
            out.value(value);
        }
    }

    public VersionedTextDocumentIdentifierTypeAdapter(Gson gson) {
        this.gson = gson;
    }

    @Override
    public VersionedTextDocumentIdentifier read(JsonReader in) throws IOException {
        JsonToken nextToken = in.peek();
        if (nextToken == JsonToken.NULL) {
            return null;
        }
        VersionedTextDocumentIdentifier result = new VersionedTextDocumentIdentifier();
        in.beginObject();
        block8: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "version": {
                    result.setVersion(this.readVersion(in));
                    continue block8;
                }
                case "uri": {
                    result.setUri(this.readUri(in));
                    continue block8;
                }
            }
            in.skipValue();
        }
        in.endObject();
        return result;
    }

    protected Integer readVersion(JsonReader in) throws IOException {
        return (Integer)this.gson.fromJson(in, (Type)((Object)Integer.class));
    }

    protected String readUri(JsonReader in) throws IOException {
        return (String)this.gson.fromJson(in, (Type)((Object)String.class));
    }

    @Override
    public void write(JsonWriter out, VersionedTextDocumentIdentifier value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("version");
        this.writeVersion(out, value.getVersion());
        out.name("uri");
        this.writeUri(out, value.getUri());
        out.endObject();
    }

    protected void writeUri(JsonWriter out, String value) throws IOException {
        out.value(value);
    }

    public static class Factory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!VersionedTextDocumentIdentifier.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            return new VersionedTextDocumentIdentifierTypeAdapter(gson);
        }
    }
}

