/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateMarkersOperation;
import org.eclipse.ui.ide.undo.DeleteMarkersOperation;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.TextEditorMessages;
import org.osgi.framework.Bundle;

public class MarkerRulerAction
extends ResourceAction
implements IUpdate {
    private static final int MAX_LABEL_LENGTH = 80;
    private final IVerticalRulerInfo fRuler;
    private final ITextEditor fTextEditor;
    private final String fMarkerType;
    private List<IMarker> fMarkers;
    private final boolean fAskForLabel;
    private final ResourceBundle fBundle;
    private final String fPrefix;
    private final String fAddLabel;
    private final String fRemoveLabel;

    public MarkerRulerAction(ResourceBundle bundle, String prefix, ITextEditor editor, IVerticalRulerInfo ruler, String markerType, boolean askForLabel) {
        super(bundle, prefix);
        Assert.isLegal((editor != null ? 1 : 0) != 0);
        this.fRuler = ruler;
        this.fTextEditor = editor;
        this.fMarkerType = markerType;
        this.fAskForLabel = askForLabel;
        this.fBundle = bundle;
        this.fPrefix = prefix;
        this.fAddLabel = MarkerRulerAction.getString((ResourceBundle)bundle, (String)(prefix + "add.label"), (String)(prefix + "add.label"));
        this.fRemoveLabel = MarkerRulerAction.getString((ResourceBundle)bundle, (String)(prefix + "remove.label"), (String)(prefix + "remove.label"));
    }

    @Deprecated
    public MarkerRulerAction(ResourceBundle bundle, String prefix, IVerticalRuler ruler, ITextEditor editor, String markerType, boolean askForLabel) {
        this(bundle, prefix, editor, (IVerticalRulerInfo)ruler, markerType, askForLabel);
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    @Deprecated
    protected IVerticalRuler getVerticalRuler() {
        IVerticalRulerInfo iVerticalRulerInfo = this.fRuler;
        if (iVerticalRulerInfo instanceof IVerticalRuler) {
            IVerticalRuler verticalRuler = (IVerticalRuler)iVerticalRulerInfo;
            return verticalRuler;
        }
        return null;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRuler;
    }

    protected ResourceBundle getResourceBundle() {
        return this.fBundle;
    }

    protected String getResourceKeyPrefix() {
        return this.fPrefix;
    }

    public void update() {
        IDocument document = this.getDocument();
        if (document != null) {
            int line = this.getVerticalRuler().getLineOfLastMouseButtonActivity() + 1;
            if (line > document.getNumberOfLines()) {
                this.setEnabled(false);
                this.setText(this.fAddLabel);
            } else {
                this.fMarkers = this.getMarkers();
                this.setEnabled(this.getResource() != null && (this.fMarkers.isEmpty() || this.markersUserEditable(this.fMarkers)));
                this.setText(this.fMarkers.isEmpty() ? this.fAddLabel : this.fRemoveLabel);
            }
        }
    }

    private boolean markersUserEditable(List<IMarker> markers) {
        Iterator<IMarker> iter = markers.iterator();
        while (iter.hasNext()) {
            if (this.isUserEditable(iter.next())) continue;
            return false;
        }
        return true;
    }

    private boolean isUserEditable(IMarker marker) {
        return marker != null && marker.exists() && marker.getAttribute("userEditable", true);
    }

    public void run() {
        if (this.fMarkers.isEmpty()) {
            this.addMarker();
        } else {
            this.removeMarkers(this.fMarkers);
        }
    }

    protected IResource getResource() {
        IEditorInput input = this.fTextEditor.getEditorInput();
        IResource resource = (IResource)input.getAdapter(IFile.class);
        if (resource == null) {
            resource = (IResource)input.getAdapter(IResource.class);
        }
        return resource;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            AbstractMarkerAnnotationModel markerModel = (AbstractMarkerAnnotationModel)model;
            return markerModel;
        }
        return null;
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    protected boolean includesRulerLine(Position position, IDocument document) {
        if (position != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = this.fRuler.getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    protected void handleCoreException(CoreException exception, String message) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        ILog log = ILog.of((Bundle)bundle);
        if (message != null) {
            log.log((IStatus)new Status(4, "org.eclipse.ui", 0, message, (Throwable)exception));
        } else {
            log.log(exception.getStatus());
        }
        Shell shell = this.getTextEditor().getSite().getShell();
        String title = MarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(this.fPrefix + "error.dialog.title"), (String)(this.fPrefix + "error.dialog.title"));
        String msg = MarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(this.fPrefix + "error.dialog.message"), (String)(this.fPrefix + "error.dialog.message"));
        ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)exception.getStatus());
    }

    protected List<IMarker> getMarkers() {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        IResource resource = this.getResource();
        IDocument document = this.getDocument();
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (resource != null && model != null && resource.exists()) {
            try {
                IMarker[] allMarkers = resource.findMarkers(this.fMarkerType, true, 0);
                if (allMarkers != null) {
                    IMarker[] iMarkerArray = allMarkers;
                    int n = allMarkers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker allMarker = iMarkerArray[n2];
                        if (this.includesRulerLine(model.getMarkerPosition(allMarker), document)) {
                            markers.add(allMarker);
                        }
                        ++n2;
                    }
                }
            }
            catch (CoreException x) {
                this.handleCoreException(x, TextEditorMessages.MarkerRulerAction_getMarker);
            }
        }
        return markers;
    }

    protected void addMarker() {
        IResource resource = this.getResource();
        if (resource == null) {
            return;
        }
        Map<String, Object> attributes = this.getInitialAttributes();
        if (this.fAskForLabel && !this.askForLabel(attributes)) {
            return;
        }
        this.execute((IUndoableOperation)new CreateMarkersOperation(this.fMarkerType, attributes, resource, this.getOperationName()));
    }

    protected void removeMarkers(List<? extends IMarker> markers) {
        IMarker[] markersArray = markers.toArray(new IMarker[markers.size()]);
        this.execute((IUndoableOperation)new DeleteMarkersOperation(markersArray, this.getOperationName()));
    }

    protected boolean askForLabel(Map<String, Object> attributes) {
        String s;
        Object o = attributes.get("message");
        String proposal = o instanceof String ? (s = (String)o) : "";
        String title = MarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(this.fPrefix + "add.dialog.title"), (String)(this.fPrefix + "add.dialog.title"));
        String message = MarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(this.fPrefix + "add.dialog.message"), (String)(this.fPrefix + "add.dialog.message"));
        String addButtonText = MarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(this.fPrefix + "add.dialog.addbutton"), (String)(this.fPrefix + "add.dialog.addbutton"));
        IInputValidator inputValidator = newText -> newText == null || newText.trim().isEmpty() ? " " : null;
        AddBookmarkDialog dialog = new AddBookmarkDialog(this.fTextEditor.getSite().getShell(), title, message, proposal, inputValidator, addButtonText);
        String label = null;
        if (dialog.open() != 1) {
            label = dialog.getValue();
        }
        if (label == null) {
            return false;
        }
        if ((label = label.trim()).isEmpty()) {
            return false;
        }
        MarkerUtilities.setMessage(attributes, label);
        return true;
    }

    protected Map<String, Object> getInitialAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>(11);
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IDocument document = provider.getDocument((Object)this.fTextEditor.getEditorInput());
        int line = this.fRuler.getLineOfLastMouseButtonActivity();
        int start = -1;
        int end = -1;
        int length = 0;
        try {
            IRegion lineInformation = document.getLineInformation(line);
            start = lineInformation.getOffset();
            length = lineInformation.getLength();
            end = start + length;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        MarkerUtilities.setMessage(attributes, this.getLabelProposal(document, start, length));
        MarkerUtilities.setLineNumber(attributes, line + 1);
        MarkerUtilities.setCharStart(attributes, start);
        MarkerUtilities.setCharEnd(attributes, end);
        return attributes;
    }

    protected String getLabelProposal(IDocument document, int offset, int length) {
        try {
            String label = document.get(offset, length).trim();
            if (label.length() <= 80) {
                return label;
            }
            return label.substring(0, 80);
        }
        catch (BadLocationException x) {
            return null;
        }
    }

    private String getOperationName() {
        String name = this.getText();
        return name == null ? TextEditorMessages.AddMarkerAction_addMarker : name;
    }

    private void execute(IUndoableOperation operation) {
        final Shell shell = this.getTextEditor().getSite().getShell();
        IAdaptable context = new IAdaptable(){

            public <T> T getAdapter(Class<T> adapter) {
                if (adapter == Shell.class) {
                    return (T)shell;
                }
                return null;
            }
        };
        IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
        try {
            operationHistory.execute(operation, null, context);
        }
        catch (ExecutionException e) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
            ILog log = ILog.of((Bundle)bundle);
            String msg = MarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(this.fPrefix + "error.dialog.message"), (String)(this.fPrefix + "error.dialog.message"));
            log.log((IStatus)new Status(4, "org.eclipse.ui", 0, msg, (Throwable)e));
        }
    }

    class AddBookmarkDialog
    extends InputDialog {
        private final String addButtonText;

        public AddBookmarkDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator, String addButtonText) {
            super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
            this.addButtonText = addButtonText;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            Button okButton = this.getOkButton();
            okButton.setText(this.addButtonText);
        }
    }
}

