/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.ui.internal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class ImageUtil {
    private static final String COMMA = ",";

    public static int getHeight(double aspectRatio, int widthHint, int heightHint) {
        return (int)Math.min((double)heightHint, (double)widthHint / aspectRatio);
    }

    public static int getWidth(double aspectRatio, int widthHint, int heightHint) {
        return (int)Math.min((double)widthHint, (double)heightHint * aspectRatio);
    }

    public static ImageData decodeToImage(String base64Image) throws IOException {
        if (base64Image == null) {
            return null;
        }
        String image = ImageUtil.processB64String(base64Image);
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] imageByte = decoder.decode(image);
        Throwable throwable = null;
        Object var5_6 = null;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);){
            return new ImageData((InputStream)bis);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String decodeFromImage(Image image, int format) {
        if (image == null) {
            return null;
        }
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData()};
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        loader.save((OutputStream)bos, format);
        Base64.Encoder encoder = Base64.getEncoder();
        return ImageUtil.getHeader(format) + encoder.encodeToString(bos.toByteArray());
    }

    private static String getHeader(int format) {
        return "data:image/" + ImageUtil.getExtension(format) + ";base64,";
    }

    private static String getExtension(int format) {
        switch (format) {
            case 0: {
                return "bmp";
            }
            case 1: {
                return "bmp";
            }
            case 2: {
                return "gif";
            }
            case 3: {
                return "ico";
            }
            case 4: {
                return "jpeg";
            }
        }
        return "png";
    }

    private static String processB64String(String base64Image) {
        int index = base64Image.substring(0, 50).indexOf(COMMA) + 1;
        return base64Image.substring(index);
    }
}

