/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DisjunctionMatchesIterator;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;

abstract class AbstractMultiTermQueryConstantScoreWrapper<Q extends MultiTermQuery>
extends Query
implements Accountable {
    static final int BOOLEAN_REWRITE_TERM_COUNT_THRESHOLD = 16;
    protected final Q query;

    protected AbstractMultiTermQueryConstantScoreWrapper(Q query) {
        this.query = query;
    }

    @Override
    public long ramBytesUsed() {
        if (this.query instanceof Accountable) {
            return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.NUM_BYTES_OBJECT_REF) + ((Accountable)this.query).ramBytesUsed();
        }
        return RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.NUM_BYTES_OBJECT_REF + 1024;
    }

    @Override
    public String toString(String field) {
        return ((Query)this.query).toString(field);
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && ((MultiTermQuery)this.query).equals(((AbstractMultiTermQueryConstantScoreWrapper)other).query);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + ((MultiTermQuery)this.query).hashCode();
    }

    public Q getQuery() {
        return this.query;
    }

    public String getField() {
        return ((MultiTermQuery)this.query).getField();
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.getField())) {
            ((Query)this.query).visit(visitor.getSubVisitor(BooleanClause.Occur.FILTER, this));
        }
    }

    protected static abstract class RewritingWeight
    extends ConstantScoreWeight {
        private final MultiTermQuery q;
        private final ScoreMode scoreMode;
        private final IndexSearcher searcher;

        protected RewritingWeight(MultiTermQuery q, float boost, ScoreMode scoreMode, IndexSearcher searcher) {
            super(q, boost);
            this.q = q;
            this.scoreMode = scoreMode;
            this.searcher = searcher;
        }

        protected abstract WeightOrDocIdSetIterator rewriteInner(LeafReaderContext var1, int var2, Terms var3, TermsEnum var4, List<TermAndState> var5, long var6) throws IOException;

        private WeightOrDocIdSetIterator rewriteAsBooleanQuery(LeafReaderContext context, List<TermAndState> collectedTerms) throws IOException {
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            for (TermAndState t : collectedTerms) {
                TermStates termStates = new TermStates(this.searcher.getTopReaderContext());
                termStates.register(t.state, context.ord, t.docFreq, t.totalTermFreq);
                bq.add(new TermQuery(new Term(this.q.field, t.term), termStates), BooleanClause.Occur.SHOULD);
            }
            ConstantScoreQuery q = new ConstantScoreQuery(bq.build());
            Weight weight = this.searcher.rewrite(q).createWeight(this.searcher, this.scoreMode, this.score());
            return new WeightOrDocIdSetIterator(weight);
        }

        private boolean collectTerms(int fieldDocCount, TermsEnum termsEnum, List<TermAndState> terms) throws IOException {
            int threshold = Math.min(16, IndexSearcher.getMaxClauseCount());
            for (int i = 0; i < threshold; ++i) {
                BytesRef term = termsEnum.next();
                if (term == null) {
                    return true;
                }
                TermState state = termsEnum.termState();
                int docFreq = termsEnum.docFreq();
                TermAndState termAndState = new TermAndState(BytesRef.deepCopyOf(term), state, docFreq, termsEnum.totalTermFreq());
                if (fieldDocCount == docFreq) {
                    terms.clear();
                    terms.add(termAndState);
                    return true;
                }
                terms.add(termAndState);
            }
            return termsEnum.next() == null;
        }

        private Scorer scorerForIterator(DocIdSetIterator iterator) {
            if (iterator == null) {
                return null;
            }
            return new ConstantScoreScorer(this.score(), this.scoreMode, iterator);
        }

        @Override
        public Matches matches(LeafReaderContext context, int doc) throws IOException {
            Terms terms = context.reader().terms(this.q.field);
            if (terms == null) {
                return null;
            }
            return MatchesUtils.forField(this.q.field, () -> DisjunctionMatchesIterator.fromTermsEnum(context, doc, this.q, this.q.field, this.q.getTermsEnum(terms)));
        }

        @Override
        public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
            long cost;
            Terms terms = context.reader().terms(this.q.getField());
            if (terms == null) {
                return null;
            }
            assert (terms != null);
            int fieldDocCount = terms.getDocCount();
            TermsEnum termsEnum = this.q.getTermsEnum(terms);
            assert (termsEnum != null);
            ArrayList<TermAndState> collectedTerms = new ArrayList<TermAndState>();
            boolean collectResult = this.collectTerms(fieldDocCount, termsEnum, collectedTerms);
            if (collectResult) {
                if (collectedTerms.isEmpty()) {
                    return null;
                }
                long sumTermCost = 0L;
                for (TermAndState collectedTerm : collectedTerms) {
                    sumTermCost += (long)collectedTerm.docFreq;
                }
                cost = sumTermCost;
            } else {
                cost = RewritingWeight.estimateCost(terms, this.q.getTermsCount());
            }
            final IOLongFunction<WeightOrDocIdSetIterator> weightOrIteratorSupplier = leadCost -> {
                if (collectResult) {
                    return this.rewriteAsBooleanQuery(context, collectedTerms);
                }
                return this.rewriteInner(context, fieldDocCount, terms, termsEnum, collectedTerms, leadCost);
            };
            return new ScorerSupplier(){

                @Override
                public Scorer get(long leadCost) throws IOException {
                    WeightOrDocIdSetIterator weightOrIterator = (WeightOrDocIdSetIterator)weightOrIteratorSupplier.apply(leadCost);
                    Scorer scorer = weightOrIterator == null ? null : (weightOrIterator.weight != null ? weightOrIterator.weight.scorer(context) : this.scorerForIterator(weightOrIterator.iterator));
                    return Objects.requireNonNullElseGet(scorer, () -> new ConstantScoreScorer(this.score(), scoreMode, DocIdSetIterator.empty()));
                }

                @Override
                public BulkScorer bulkScorer() throws IOException {
                    WeightOrDocIdSetIterator weightOrIterator = (WeightOrDocIdSetIterator)weightOrIteratorSupplier.apply(Long.MAX_VALUE);
                    BulkScorer bulkScorer = weightOrIterator == null ? null : (weightOrIterator.weight != null ? weightOrIterator.weight.bulkScorer(context) : new Weight.DefaultBulkScorer(new ConstantScoreScorer(this.score(), scoreMode, weightOrIterator.iterator)));
                    return Objects.requireNonNullElseGet(bulkScorer, () -> new Weight.DefaultBulkScorer(new ConstantScoreScorer(this.score(), scoreMode, DocIdSetIterator.empty())));
                }

                @Override
                public long cost() {
                    return cost;
                }
            };
        }

        private static long estimateCost(Terms terms, long queryTermsCount) throws IOException {
            long cost;
            if (queryTermsCount == -1L) {
                cost = terms.getSumDocFreq();
            } else {
                long potentialExtraCost = terms.getSumDocFreq();
                long indexedTermCount = terms.size();
                if (indexedTermCount != -1L) {
                    potentialExtraCost -= indexedTermCount;
                }
                cost = queryTermsCount + potentialExtraCost;
            }
            return cost;
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }

        private static interface IOLongFunction<T> {
            public T apply(long var1) throws IOException;
        }
    }

    protected static final class WeightOrDocIdSetIterator {
        final Weight weight;
        final DocIdSetIterator iterator;

        WeightOrDocIdSetIterator(Weight weight) {
            this.weight = Objects.requireNonNull(weight);
            this.iterator = null;
        }

        WeightOrDocIdSetIterator(DocIdSetIterator iterator) {
            this.iterator = iterator;
            this.weight = null;
        }
    }

    protected static final class TermAndState {
        final BytesRef term;
        final TermState state;
        final int docFreq;
        final long totalTermFreq;

        TermAndState(BytesRef term, TermState state, int docFreq, long totalTermFreq) {
            this.term = term;
            this.state = state;
            this.docFreq = docFreq;
            this.totalTermFreq = totalTermFreq;
        }
    }
}

