/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.undo.snapshot.IResourceSnapshot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.ide.undo.AbstractCopyOrMoveResourcesOperation;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class MoveProjectOperation
extends AbstractCopyOrMoveResourcesOperation {
    private URI projectLocation;

    public MoveProjectOperation(IProject project, URI location, String label) {
        super(new IResource[]{project}, label);
        Assert.isLegal((project != null ? 1 : 0) != 0);
        this.projectLocation = URIUtil.toPath((URI)location).equals((Object)Platform.getLocation()) ? null : location;
    }

    @Override
    protected boolean updateResourceChangeDescriptionFactory(IResourceChangeDescriptionFactory factory, int operation) {
        return false;
    }

    private IProject getProject() {
        return (IProject)this.resources[0];
    }

    @Override
    protected boolean isDestinationPathValid(IResource resource, int index) {
        return true;
    }

    @Override
    protected String getProposedName(IResource resource, int index) {
        return this.getProject().getName();
    }

    @Override
    protected IStatus computeMoveOrCopyStatus() {
        IStatus status = Status.OK_STATUS;
        if (this.projectLocation != null) {
            status = this.getWorkspace().validateProjectLocationURI(this.getProject(), this.projectLocation);
        }
        if (status.isOK()) {
            return super.computeMoveOrCopyStatus();
        }
        return status;
    }

    @Override
    protected void doExecute(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        this.projectLocation = this.moveProject(this.getProject(), this.projectLocation, monitor);
        this.setResourceDescriptions(new IResourceSnapshot[0]);
    }

    @Override
    protected void doUndo(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        this.doExecute(monitor, uiInfo);
    }

    URI moveProject(IProject project, URI locationURI, IProgressMonitor monitor) throws CoreException {
        monitor.setTaskName(UndoMessages.AbstractCopyOrMoveResourcesOperation_moveProjectProgress);
        IProjectDescription description = project.getDescription();
        URI newDestinationURI = description.getLocationURI();
        description.setLocationURI(locationURI);
        project.move(description, 33, monitor);
        return newDestinationURI;
    }

    @Override
    public IStatus computeUndoableStatus(IProgressMonitor monitor) {
        IStatus status = super.computeUndoableStatus(monitor);
        if (status.isOK()) {
            status = this.computeMoveOrCopyStatus();
        }
        return status;
    }
}

