/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.service.CachingMarketplaceService;
import org.eclipse.epp.internal.mpc.core.service.DefaultCatalogService;
import org.eclipse.epp.internal.mpc.core.service.DefaultMarketplaceService;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientService;
import org.eclipse.epp.internal.mpc.core.util.ServiceUtil;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.epp.mpc.core.service.ICatalogService;
import org.eclipse.epp.mpc.core.service.IMarketplaceService;
import org.eclipse.epp.mpc.core.service.IMarketplaceServiceLocator;
import org.eclipse.epp.mpc.core.service.ServiceHelper;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.util.tracker.ServiceTracker;

@Component(name="org.eclipse.epp.mpc.core.servicelocator", service={IMarketplaceServiceLocator.class})
public class ServiceLocator
implements IMarketplaceServiceLocator {
    private static final String DEBUG_CLIENT_REMOVE_OPTION = "xxx";
    private static final String DEBUG_CLIENT_OPTIONS_PATH = "org.eclipse.epp.mpc.core/client/";
    private static boolean DEBUG_FAKE_CLIENT = false;
    private static final String DEBUG_OPTION = "/debug";
    private static final String DEBUG_FAKE_CLIENT_OPTION = "/client/fakeVersion";
    private static ServiceLocator instance;
    private ICatalogService catalogService;
    private ServiceTracker<IMarketplaceService, IMarketplaceService> marketplaceServiceTracker;
    private ServiceTracker<ICatalogService, ICatalogService> catalogServiceTracker;
    private URL defaultCatalogUrl;
    private URL defaultMarketplaceUrl;
    private final List<ServiceRegistration<?>> dynamicServiceRegistrations = new ArrayList();
    private HttpClientService httpClient;

    public ServiceLocator() {
        this.defaultMarketplaceUrl = DefaultMarketplaceService.DEFAULT_SERVICE_URL;
        this.defaultCatalogUrl = DefaultCatalogService.DEFAULT_CATALOG_SERVICE_URL;
    }

    public HttpClientService getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClientService httpClient) {
        HttpClientService oldClient = this.httpClient;
        this.httpClient = httpClient;
        if (oldClient != httpClient) {
            this.updateHttpClient(httpClient);
        }
    }

    @Reference(unbind="unbindHttpClient", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC)
    public void bindHttpClient(HttpClientService httpClient) {
        this.setHttpClient(httpClient);
    }

    public void unbindHttpClient(HttpClientService httpClient) {
        if (this.httpClient == httpClient) {
            this.setHttpClient(null);
        }
    }

    private void updateHttpClient(final HttpClientService httpClient) {
        ServiceLocator.applyServiceReferenceOperation(this.marketplaceServiceTracker, new ServiceReferenceOperation<IMarketplaceService>(){

            @Override
            public void apply(ServiceReference<IMarketplaceService> reference) {
                IMarketplaceService service;
                ServiceRegistration<IMarketplaceService> registration = ServiceLocator.this.getDynamicServiceInstance(reference);
                if (registration != null && (service = ServiceUtil.getService(registration)) instanceof DefaultMarketplaceService) {
                    ((DefaultMarketplaceService)service).setHttpClient(httpClient);
                }
            }
        });
    }

    @Deprecated
    public IMarketplaceService getMarketplaceService() {
        return this.getDefaultMarketplaceService();
    }

    @Override
    public IMarketplaceService getDefaultMarketplaceService() {
        return this.getMarketplaceService(this.defaultMarketplaceUrl.toExternalForm());
    }

    @Override
    public synchronized IMarketplaceService getMarketplaceService(String baseUrl) {
        IMarketplaceService service = this.getService(this.marketplaceServiceTracker, baseUrl);
        if (service != null) {
            return service;
        }
        service = this.createMarketplaceService(baseUrl);
        this.registerService(baseUrl, IMarketplaceService.class, service);
        return service;
    }

    private <T> void registerService(String baseUrl, Class<T> serviceClass, T service) {
        this.registerService(baseUrl, serviceClass, service, null);
    }

    private <T> ServiceRegistration<T> registerService(String baseUrl, Class<T> serviceClass, T service, Dictionary<String, Object> properties) {
        if (baseUrl != null) {
            if (properties == null) {
                properties = new Hashtable<String, Object>(1);
            }
            properties.put("url", baseUrl);
        }
        ServiceRegistration registration = FrameworkUtil.getBundle(IMarketplaceServiceLocator.class).getBundleContext().registerService(serviceClass, service, properties);
        this.dynamicServiceRegistrations.add(registration);
        return registration;
    }

    private <T> T getService(ServiceTracker<T, T> serviceTracker, String baseUrl) {
        ServiceReference[] serviceReferences;
        if (serviceTracker != null && (serviceReferences = serviceTracker.getServiceReferences()) != null) {
            ServiceReference[] serviceReferenceArray = serviceReferences;
            int n = serviceReferences.length;
            int n2 = 0;
            while (n2 < n) {
                Object service;
                ServiceReference serviceReference = serviceReferenceArray[n2];
                Object serviceBaseUrl = ServiceUtil.getOverridablePropertyValue(serviceReference, "url");
                if (baseUrl.equals(serviceBaseUrl) && (service = serviceTracker.getService(serviceReference)) != null) {
                    return (T)service;
                }
                ++n2;
            }
        }
        return null;
    }

    protected IMarketplaceService createMarketplaceService(String baseUrl) {
        URL base;
        try {
            base = URLUtil.toURL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        DefaultMarketplaceService defaultService = new DefaultMarketplaceService(base);
        Map<String, String> requestMetaParameters = ServiceLocator.computeDefaultRequestMetaParameters();
        defaultService.setRequestMetaParameters(requestMetaParameters);
        defaultService.setHttpClient(this.httpClient);
        CachingMarketplaceService service = new CachingMarketplaceService(defaultService);
        return service;
    }

    private void unregisterService(ServiceRegistration<?> registration) {
        if (registration != null) {
            this.dynamicServiceRegistrations.remove(registration);
            registration.unregister();
        }
    }

    public synchronized void activate(BundleContext context, Map<?, ?> properties) {
        URL marketplaceUrl;
        URL baseUrl = ServiceUtil.getUrl(properties, "url", null);
        URL catalogUrl = ServiceUtil.getUrl(properties, "catalogUrl", baseUrl);
        if (catalogUrl != null) {
            this.defaultCatalogUrl = catalogUrl;
        }
        if ((marketplaceUrl = ServiceUtil.getUrl(properties, "marketplaceUrl", baseUrl)) != null) {
            this.defaultMarketplaceUrl = marketplaceUrl;
        }
        this.marketplaceServiceTracker = new ServiceTracker(context, IMarketplaceService.class, null);
        this.marketplaceServiceTracker.open(true);
        this.catalogServiceTracker = new ServiceTracker(context, ICatalogService.class, null);
        this.catalogServiceTracker.open(true);
    }

    private static <T> void applyServiceReferenceOperation(ServiceTracker<T, ?> serviceTracker, ServiceReferenceOperation<T> op) {
        ServiceReference[] serviceReferences;
        if (serviceTracker != null && (serviceReferences = serviceTracker.getServiceReferences()) != null) {
            ServiceReference[] serviceReferenceArray = serviceReferences;
            int n = serviceReferences.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference serviceReference = serviceReferenceArray[n2];
                op.apply(serviceReference);
                ++n2;
            }
        }
    }

    private <T, R extends T> ServiceRegistration<T> getDynamicServiceInstance(ServiceReference<T> reference) {
        for (ServiceRegistration<?> serviceRegistration : this.dynamicServiceRegistrations) {
            if (!reference.equals((Object)serviceRegistration.getReference())) continue;
            ServiceRegistration<?> referencedRegistration = serviceRegistration;
            return referencedRegistration;
        }
        return null;
    }

    public synchronized void deactivate() {
        if (this.marketplaceServiceTracker != null) {
            this.marketplaceServiceTracker.close();
            this.marketplaceServiceTracker = null;
        }
        if (this.catalogServiceTracker != null) {
            this.catalogServiceTracker.close();
            this.catalogServiceTracker = null;
        }
        for (ServiceRegistration<?> serviceRegistration : this.dynamicServiceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    @Override
    public synchronized ICatalogService getCatalogService() {
        ICatalogService registeredService;
        if (this.catalogServiceTracker != null && (registeredService = (ICatalogService)this.catalogServiceTracker.getService()) != null) {
            return registeredService;
        }
        if (this.catalogService != null) {
            return this.catalogService;
        }
        DefaultCatalogService catalogService = new DefaultCatalogService(this.defaultCatalogUrl);
        this.registerService(null, ICatalogService.class, catalogService);
        return catalogService;
    }

    @Deprecated
    public static synchronized void setInstance(ServiceLocator instance) {
        ServiceLocator.instance = instance;
    }

    @Deprecated
    public static synchronized ServiceLocator getInstance() {
        if (instance != null) {
            return instance;
        }
        IMarketplaceServiceLocator locator = ServiceLocator.getCompatibilityLocator();
        if (locator != null && locator instanceof ServiceLocator) {
            return (ServiceLocator)locator;
        }
        instance = new ServiceLocator();
        return instance;
    }

    public static synchronized IMarketplaceServiceLocator getCompatibilityLocator() {
        if (instance != null) {
            return instance;
        }
        IMarketplaceServiceLocator locator = ServiceHelper.getMarketplaceServiceLocator();
        if (locator == null) {
            instance = new ServiceLocator();
            locator = instance;
        }
        return locator;
    }

    public static Map<String, String> computeDefaultRequestMetaParameters() {
        LinkedHashMap<String, String> requestMetaParameters = new LinkedHashMap<String, String>();
        ServiceLocator.addDefaultRequestMetaParameter(requestMetaParameters, "client", "org.eclipse.epp.mpc.core");
        ServiceLocator.addDefaultRequestMetaParameter(requestMetaParameters, "os", Platform.getOS());
        Bundle platformBundle = Platform.getBundle((String)"org.eclipse.platform");
        ServiceLocator.addDefaultRequestMetaParameter(requestMetaParameters, "platform.version", platformBundle == null ? null : ServiceLocator.shortenVersionString(platformBundle.getVersion().toString()));
        return requestMetaParameters;
    }

    public static Map<String, String> computeProductInfo() {
        Bundle productBundle;
        LinkedHashMap<String, String> productInfo = new LinkedHashMap<String, String>();
        BundleContext bundleContext = FrameworkUtil.getBundle(MarketplaceClientCore.class).getBundleContext();
        IProduct product = Platform.getProduct();
        String productId = bundleContext.getProperty("eclipse.product");
        if (productId == null && product != null) {
            productId = product.getId();
        }
        ServiceLocator.addDefaultRequestMetaParameter(productInfo, "product", productId);
        String productVersion = null;
        if (productId != null && (productVersion = bundleContext.getProperty("eclipse.buildId")) == null && product != null && (productBundle = product.getDefiningBundle()) != null) {
            productVersion = productBundle.getVersion().toString();
        }
        ServiceLocator.addDefaultRequestMetaParameter(productInfo, "product.version", productVersion);
        return productInfo;
    }

    private static void addDefaultRequestMetaParameter(Map<String, String> requestMetaParameters, String key, String value) {
        if (DEBUG_FAKE_CLIENT) {
            String debugOption = Platform.getDebugOption((String)(DEBUG_CLIENT_OPTIONS_PATH + key));
            if (DEBUG_CLIENT_REMOVE_OPTION.equals(debugOption)) {
                requestMetaParameters.remove(key);
                return;
            }
            if (debugOption != null && !"".equals(debugOption)) {
                value = debugOption;
            }
        }
        if (value != null) {
            requestMetaParameters.put(key, value);
        }
    }

    private static String shortenVersionString(String version) {
        int index = version.indexOf(46);
        if (index > -1 && (index = version.indexOf(46, index + 1)) > -1) {
            return version.substring(0, index);
        }
        return version;
    }

    @Component(name="org.eclipse.epp.mpc.core.debug.options", property={"listener.symbolic.name=org.eclipse.epp.mpc.core"})
    public static class DebugOptionsInitializer
    implements DebugOptionsListener {
        public void optionsChanged(DebugOptions options) {
            boolean debug = options.getBooleanOption("org.eclipse.epp.mpc.core/debug", false);
            boolean fakeClient = false;
            if (debug) {
                fakeClient = options.getBooleanOption("org.eclipse.epp.mpc.core/client/fakeVersion", false);
            }
            DEBUG_FAKE_CLIENT = fakeClient;
        }
    }

    private abstract class DynamicBindingOperation<T, B>
    implements ServiceReferenceOperation<T> {
        private final String dynamicBindId;
        private final ServiceReference<B> binding;

        public DynamicBindingOperation(String dynamicBindId, ServiceReference<B> binding) {
            this.dynamicBindId = dynamicBindId;
            this.binding = binding;
        }

        @Override
        public void apply(ServiceReference<T> reference) {
            ServiceRegistration<T> registration = ServiceLocator.this.getDynamicServiceInstance(reference);
            if (registration != null) {
                Dictionary<String, Object> properties = ServiceUtil.getProperties(reference);
                if (properties.get(this.dynamicBindId) != null) {
                    return;
                }
                T service = ServiceUtil.getService(registration);
                B currentBinding = service == null ? null : (B)this.getCurrentBinding(service);
                this.apply(service, currentBinding, registration, properties);
            }
        }

        protected void apply(T service, B currentBinding, ServiceRegistration<T> registration, Dictionary<String, Object> properties) {
            if (service != null && currentBinding == null) {
                properties.put(this.dynamicBindId, this.binding);
                registration.setProperties(properties);
            }
        }

        protected abstract B getCurrentBinding(T var1);
    }

    private static interface ServiceReferenceOperation<T> {
        public void apply(ServiceReference<T> var1);
    }
}

