/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.html;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.mylyn.wikitext.html.HtmlLanguage;
import org.eclipse.mylyn.wikitext.html.internal.FontElementStrategy;
import org.eclipse.mylyn.wikitext.html.internal.HtmlSubsetLanguage;
import org.eclipse.mylyn.wikitext.html.internal.LiteralHtmlDocumentHandler;
import org.eclipse.mylyn.wikitext.html.internal.SpanHtmlElementStrategy;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;

public class HtmlLanguageBuilder {
    private String name;
    private final Set<DocumentBuilder.BlockType> blockTypes = new HashSet<DocumentBuilder.BlockType>();
    private final Set<DocumentBuilder.SpanType> spanTypes = new HashSet<DocumentBuilder.SpanType>();
    private final Map<DocumentBuilder.SpanType, String> spanTypeToElementNameSubstitution = new HashMap<DocumentBuilder.SpanType, String>();
    private final List<SpanHtmlElementStrategy> spanElementStrategies = new ArrayList<SpanHtmlElementStrategy>();
    private int headingLevel;
    private LiteralHtmlDocumentHandler documentHandler;
    private boolean xhtmlStrict;
    private boolean supportsImages = true;

    HtmlLanguageBuilder() {
    }

    public HtmlLanguageBuilder name(String name) {
        Objects.requireNonNull(name, "Must provide a name");
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)name), (String)"Name must not be empty", (Object[])new Object[0]);
        Validate.isTrue((!name.equalsIgnoreCase("HTML") ? 1 : 0) != 0, (String)"Name must not be equal to %s", (Object[])new Object[]{"HTML"});
        Validate.isTrue((boolean)name.equals(name.trim()), (String)"Name must not have leading or trailing whitespace", (Object[])new Object[0]);
        this.name = name;
        return this;
    }

    public HtmlLanguageBuilder add(DocumentBuilder.BlockType blockType) {
        this.blockTypes.add(Objects.requireNonNull(blockType, "Must provide a blockType"));
        return this;
    }

    public HtmlLanguageBuilder add(DocumentBuilder.SpanType spanType) {
        this.spanTypes.add(Objects.requireNonNull(spanType, "Must provide a spanType"));
        return this;
    }

    public HtmlLanguageBuilder addSubstitution(DocumentBuilder.SpanType spanType, String alternativeTagName) {
        Objects.requireNonNull(spanType, "Must provide a spanType");
        Objects.requireNonNull(alternativeTagName, "Must provide an alternativeTagName");
        this.spanTypeToElementNameSubstitution.put(spanType, alternativeTagName);
        return this;
    }

    public HtmlLanguageBuilder addHeadings(int level) {
        Validate.isTrue((level > 0 && level <= 6 ? 1 : 0) != 0, (String)"Heading level must be between 1 and 6", (Object[])new Object[0]);
        this.headingLevel = level;
        return this;
    }

    public HtmlLanguageBuilder addSpanFont() {
        this.spanElementStrategies.add(new FontElementStrategy());
        return this;
    }

    public HtmlLanguageBuilder setXhtmlStrict(boolean xhtmlStrict) {
        this.xhtmlStrict = xhtmlStrict;
        return this;
    }

    public HtmlLanguageBuilder document(String prefix, String suffix) {
        Objects.requireNonNull(prefix, "Must provide a prefix");
        Objects.requireNonNull(suffix, "Must provide a suffix");
        this.documentHandler = new LiteralHtmlDocumentHandler(prefix, suffix);
        return this;
    }

    public HtmlLanguageBuilder setSupportsImages(boolean supportsImages) {
        this.supportsImages = supportsImages;
        return this;
    }

    public HtmlLanguage create() {
        Validate.isTrue((this.name != null ? 1 : 0) != 0, (String)"Name must be provided to create an HtmlLanguage", (Object[])new Object[0]);
        return new HtmlSubsetLanguage(this.name, this.documentHandler, this.headingLevel, this.blockTypes, this.spanTypes, this.spanTypeToElementNameSubstitution, this.spanElementStrategies, this.xhtmlStrict, this.supportsImages);
    }
}

