/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;

public class ToggleTaskActivationAction
extends Action
implements ITaskActivationListener {
    public static final String ID = "org.eclipse.mylyn.tasks.ui.actions.task.activation.toggle";
    private final ITask task;

    public ToggleTaskActivationAction(ITask task) {
        Assert.isNotNull((Object)task);
        this.task = task;
        this.setId(ID);
        this.setImageDescriptor(TasksUiImages.CONTEXT_ACTIVE_CENTERED);
        this.update();
        TasksUi.getTaskActivityManager().addActivationListener((ITaskActivationListener)this);
    }

    public void dispose() {
        TasksUi.getTaskActivityManager().removeActivationListener((ITaskActivationListener)this);
    }

    private void update() {
        this.setChecked(this.task.isActive());
        if (this.task.isActive()) {
            this.setText(Messages.ToggleTaskActivationAction_Deactivate_Task);
            this.setToolTipText(Messages.ToggleTaskActivationAction_Deactivate_Task);
        } else {
            this.setText(Messages.ToggleTaskActivationAction_Activate_Task);
            this.setToolTipText(Messages.ToggleTaskActivationAction_Activate_Task);
        }
    }

    public void run() {
        if (!this.task.isActive()) {
            TasksUiInternal.activateTaskThroughCommand(this.task);
        } else {
            TasksUi.getTaskActivityManager().deactivateTask(this.task);
        }
        this.update();
    }

    public void taskActivated(ITask task) {
        this.update();
    }

    public void taskDeactivated(ITask task) {
        this.update();
    }

    public void preTaskActivated(ITask task) {
    }

    public void preTaskDeactivated(ITask task) {
    }
}

