/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.internal.core.operations;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.internal.core.Build;
import org.eclipse.mylyn.builds.internal.core.BuildServer;
import org.eclipse.mylyn.builds.internal.core.operations.AbstractElementOperation;
import org.eclipse.mylyn.builds.internal.core.operations.BuildJob;
import org.eclipse.mylyn.builds.internal.core.operations.IOperationService;
import org.eclipse.mylyn.builds.internal.core.operations.Messages;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.osgi.util.NLS;

public class GetBuildOutputOperation
extends AbstractElementOperation<IBuild> {
    private final IBuild build;
    private final BuildServer server;
    private final BuildOutputReader reader;

    public GetBuildOutputOperation(IOperationService service, IBuild build, BuildOutputReader reader) {
        super(service);
        Assert.isNotNull((Object)build);
        Assert.isNotNull((Object)reader);
        this.build = build;
        this.reader = reader;
        this.server = (BuildServer)build.getServer();
    }

    public void doGetOutput(IBuild build, IOperationMonitor monitor) throws CoreException {
        try {
            try {
                Reader in = this.server.getBehaviour().getConsole(build, monitor);
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    try {
                        BuildOutputEvent event = new BuildOutputEvent();
                        event.input = new BufferedReader(in);
                        this.reader.handle(event, monitor);
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.builds.core", Messages.GetBuildOutputOperation_failedRetrievingOutput, (Throwable)e));
            }
        }
        finally {
            this.reader.done();
        }
    }

    @Override
    protected BuildJob doCreateJob(final IBuild build) {
        return new BuildJob(NLS.bind((String)Messages.GetBuildOutputOperation_retrievingOutputForBuild, (Object)(build.getPlan() == null ? Messages.GetBuildOutputOperation_unknown : build.getPlan().getLabel()), (Object)build.getLabel())){

            @Override
            protected IStatus doExecute(IOperationMonitor monitor) {
                try {
                    GetBuildOutputOperation.this.doGetOutput(build, monitor);
                }
                catch (CoreException e) {
                    this.setStatus((IStatus)new Status(4, "org.eclipse.mylyn.builds.core", NLS.bind((String)Messages.GetBuildOutputOperation_unexpectedError, (Object)build.getName()), (Throwable)e));
                }
                catch (OperationCanceledException e) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
    }

    @Override
    protected List<IBuild> doSyncInitInput() {
        return Collections.singletonList(((Build)this.build).createWorkingCopy());
    }

    public static class BuildOutputEvent {
        private BufferedReader input;

        public BufferedReader getInput() {
            return this.input;
        }
    }

    public static abstract class BuildOutputReader {
        public abstract void handle(BuildOutputEvent var1, IOperationMonitor var2) throws IOException, CoreException;

        public abstract void done();
    }
}

