/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jgit.util.LfsFactory;

public class InstallLfsLocalCommand
extends RepositoriesViewCommandHandler<RepositoryNode> {
    public static final String ID = "org.eclipse.egit.ui.team.InstallLfsLocal";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List selectedNodes;
        if (!LfsFactory.getInstance().isAvailable()) {
            return null;
        }
        try {
            selectedNodes = this.getSelectedNodes(event);
            if (selectedNodes.isEmpty()) {
                return null;
            }
        }
        catch (ExecutionException e) {
            Activator.handleError(e.getMessage(), e, true);
            return null;
        }
        for (RepositoryNode n : selectedNodes) {
            try {
                LfsFactory.LfsInstallCommand cmd = LfsFactory.getInstance().getInstallCommand();
                if (cmd == null) continue;
                cmd.setRepository(n.getRepository()).call();
            }
            catch (Exception e) {
                Activator.handleError(UIText.ConfigurationChecker_installLfsCannotInstall, e, false);
            }
        }
        return null;
    }
}

