/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation.handlers;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.oomph.setup.presentation.SetupEditorPlugin;
import org.eclipse.oomph.setup.ui.SetupPropertyTester;
import org.eclipse.oomph.setup.ui.wizards.ProgressPage;
import org.eclipse.oomph.ui.ButtonAnimator;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class PerformStatusControl
extends WorkbenchWindowControlContribution {
    protected void resetPerforming() {
        SetupPropertyTester.setPerformingShell(null);
        SetupPropertyTester.setPerformingStatus(null);
    }

    protected Control createControl(final Composite parent) {
        final ToolBar toolBar = new ToolBar(parent, 0x800100);
        final ToolItem toolItem = new ToolItem(toolBar, 32);
        toolItem.setImage(SetupEditorPlugin.INSTANCE.getSWTImage("progress0.png"));
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = SetupPropertyTester.getPerformingShell();
                if (shell != null) {
                    boolean visible = !shell.isVisible();
                    shell.setVisible(visible);
                    if (SetupPropertyTester.getPerformingStatus() != null) {
                        PerformStatusControl.this.resetPerforming();
                    }
                    if (visible) {
                        shell.setFocus();
                    }
                }
            }
        });
        if (OS.INSTANCE.isLinux()) {
            toolBar.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    parent.pack();
                    toolBar.removeControlListener((ControlListener)this);
                }
            });
        }
        ButtonAnimator buttonAnimator = new ButtonAnimator(SetupEditorPlugin.INSTANCE, toolItem, "progress.png", 7, true){
            private boolean done;
            private boolean fixed;

            public void run() {
                if (!toolItem.isDisposed()) {
                    if (!this.fixed || !toolBar.isVisible()) {
                        this.fixed = PerformStatusControl.this.fixPosition();
                    }
                    super.run();
                }
            }

            public Shell getShell() {
                Shell shell = SetupPropertyTester.getPerformingShell();
                if (shell != null && !shell.isDisposed()) {
                    IStatus status;
                    String text;
                    boolean visible = shell.isVisible();
                    if (toolItem.getSelection() != visible) {
                        toolItem.setSelection(visible);
                    }
                    if (!(text = shell.getText()).equals(toolItem.getToolTipText())) {
                        toolItem.setToolTipText(text);
                    }
                    if ((status = SetupPropertyTester.getPerformingStatus()) == null && (status = (IStatus)shell.getData("org.eclipse.oomph.setup.status")) != null) {
                        String statusImage;
                        SetupPropertyTester.setPerformingStatus((IStatus)status);
                        switch (status.getSeverity()) {
                            case 0: {
                                statusImage = "progress_success.png";
                                this.delayedDispose(shell);
                                break;
                            }
                            case 2: {
                                statusImage = "progress_warning.png";
                                break;
                            }
                            case 4: {
                                statusImage = "progress_error.png";
                                break;
                            }
                            case 8: {
                                statusImage = "progress_cancel.png";
                                this.delayedDispose(shell);
                                break;
                            }
                            default: {
                                statusImage = "progress.png";
                            }
                        }
                        if (this.images == null) {
                            this.images = new Image[1 + this.additionalImages];
                        }
                        int i = 0;
                        while (i < this.images.length) {
                            this.images[i] = SetupEditorPlugin.INSTANCE.getSWTImage(i >= 4 ? statusImage : "progress.png");
                            ++i;
                        }
                        this.done = true;
                    }
                }
                return shell;
            }

            protected int getQuietCycles() {
                if (this.done) {
                    return 2;
                }
                return super.getQuietCycles();
            }

            private void delayedDispose(final Shell shell) {
                UIUtil.timerExec((int)15000, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!(toolItem.isDisposed() || shell.isDisposed() || shell.isVisible())) {
                            shell.dispose();
                        }
                    }
                });
            }

            protected boolean doAnimate() {
                if (SetupPropertyTester.getPerformingStatus() != null) {
                    Shell shell = this.getShell();
                    if (shell.isVisible()) {
                        PerformStatusControl.this.resetPerforming();
                    }
                    return true;
                }
                if (Job.getJobManager().find(ProgressPage.PROGRESS_FAMILY).length == 0) {
                    PerformStatusControl.this.resetPerforming();
                }
                return true;
            }
        };
        buttonAnimator.run();
        return toolBar;
    }

    private boolean fixPosition() {
        EObject performStatusBar;
        EObject progressBar;
        IWorkbenchWindow workbenchWindow;
        block3: {
            workbenchWindow = this.getWorkbenchWindow();
            Object model = ReflectUtil.getValue((String)"model", (Object)workbenchWindow);
            Object modelService = ReflectUtil.getValue((String)"modelService", (Object)workbenchWindow);
            Class elementClass = CommonPlugin.loadClass((String)"org.eclipse.ui.workbench", (String)"org.eclipse.e4.ui.model.application.ui.MUIElement");
            Method findMethod = ReflectUtil.getMethod(modelService.getClass(), (String)"find", (Class[])new Class[]{String.class, elementClass});
            progressBar = (EObject)ReflectUtil.invokeMethod((Method)findMethod, (Object)modelService, (Object[])new Object[]{"org.eclipse.ui.ProgressBar", model});
            performStatusBar = (EObject)ReflectUtil.invokeMethod((Method)findMethod, (Object)modelService, (Object[])new Object[]{"org.eclipse.oomph.setup.status", model});
            if (progressBar != null) break block3;
            return false;
        }
        try {
            EList children = (EList)progressBar.eContainer().eGet((EStructuralFeature)progressBar.eContainmentFeature());
            children.remove((Object)performStatusBar);
            children.add(children.indexOf((Object)progressBar), (Object)performStatusBar);
            workbenchWindow.getShell().layout(true, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }
}

