/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.Platform;

final class NTLMDomainUtil {
    private static final String PROP_HTTP_AUTH_NTLM_DOMAIN = "http.auth.ntlm.domain";
    private static final String ENV_USER_DOMAIN = "USERDOMAIN";
    private static final char BACKSLASH = '\\';
    private static final char SLASH = '/';
    private static String workstation;

    private NTLMDomainUtil() {
    }

    public static String getNTLMWorkstation() {
        String hostName;
        if (workstation != null) {
            return "".equals(workstation) ? null : workstation;
        }
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            if (!(localHost.isLoopbackAddress() || (hostName = localHost.getHostName()) == null || "".equals(hostName) || "localhost".equals(hostName))) {
                workstation = hostName;
                return hostName;
            }
        }
        catch (UnknownHostException localHost) {
            // empty catch block
        }
        String computerName = System.getenv("COMPUTERNAME");
        hostName = System.getenv("HOSTNAME");
        if (computerName != null) {
            if (hostName != null && !computerName.equals(hostName)) {
                if (Platform.getOS().equals("win32")) {
                    hostName = computerName;
                }
            } else {
                hostName = computerName;
            }
        }
        if (hostName != null) {
            workstation = hostName;
            return hostName;
        }
        workstation = "";
        return null;
    }

    public static String getNTLMUserDomain(String userName) {
        String domain;
        if (userName != null) {
            int pos = userName.indexOf(92);
            if (pos != -1) {
                return userName.substring(0, pos);
            }
            pos = userName.indexOf(47);
            if (pos != -1) {
                return userName.substring(0, pos);
            }
        }
        if ((domain = System.getProperty(PROP_HTTP_AUTH_NTLM_DOMAIN)) != null) {
            return domain;
        }
        domain = System.getenv(ENV_USER_DOMAIN);
        if (domain != null) {
            return domain;
        }
        return null;
    }

    public static String getNTLMUserName(String userName) {
        if (userName != null) {
            int pos = userName.indexOf(92);
            if (userName.charAt(pos + 1) == '\\') {
                ++pos;
            }
            if (pos != -1) {
                return userName.substring(pos + 1);
            }
            pos = userName.indexOf(47);
            if (userName.charAt(pos + 1) == '/') {
                ++pos;
            }
            if (pos != -1) {
                return userName.substring(pos + 1);
            }
        }
        return userName;
    }
}

