/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.wizards;

import java.util.Map;
import org.eclipse.cdt.autotools.core.AutotoolsNewProjectNature;
import org.eclipse.cdt.build.core.scannerconfig.CfgInfoContext;
import org.eclipse.cdt.build.core.scannerconfig.ICfgScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.build.internal.core.scannerconfig2.CfgScannerConfigProfileManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.internal.autotools.core.configure.AutotoolsConfigurationManager;
import org.eclipse.cdt.internal.autotools.ui.wizards.AutotoolsWizardMessages;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSWizardHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Composite;

public class AutotoolsBuildWizardHandler
extends MBSWizardHandler {
    public AutotoolsBuildWizardHandler(Composite p, IWizard w) {
        super(AutotoolsWizardMessages.getResourceString("AutotoolsBuildWizard.0"), p, w);
    }

    public AutotoolsBuildWizardHandler(IProjectType pt, Composite parent, IWizard wizard) {
        super(pt, parent, wizard);
    }

    public void createProject(IProject project, boolean defaults, boolean onFinish, IProgressMonitor monitor) throws CoreException {
        super.createProject(project, defaults, onFinish, monitor);
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.getProjectDescription(project);
        ICConfigurationDescription cfgd = des.getActiveConfiguration();
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgd);
        ICfgScannerConfigBuilderInfo2Set cbi = CfgScannerConfigProfileManager.getCfgScannerConfigBuildInfo((IConfiguration)cfg);
        IScannerConfigBuilderInfo2Set baseCbi = ScannerConfigProfileManager.createScannerConfigBuildInfo2Set((IProject)project);
        Map baseInfoMap = baseCbi.getInfoMap();
        Map infoMap = cbi.getInfoMap();
        for (Map.Entry e : infoMap.entrySet()) {
            String s = null;
            CfgInfoContext cfgInfoContext = (CfgInfoContext)e.getKey();
            IResourceInfo rcInfo = cfgInfoContext.getResourceInfo();
            if (rcInfo == null) {
                s = cfgInfoContext.getConfiguration().getName();
            } else {
                IInputType typ = cfgInfoContext.getInputType();
                s = typ.getName();
            }
            IScannerConfigBuilderInfo2 bi2 = (IScannerConfigBuilderInfo2)infoMap.get(cfgInfoContext);
            String profileId = bi2.getSelectedProfileId();
            bi2.setSelectedProfileId(profileId);
        }
        CoreModel.getDefault().setProjectDescription(project, des);
    }

    public void convertProject(IProject proj, IProgressMonitor monitor) throws CoreException {
        super.convertProject(proj, monitor);
        AutotoolsNewProjectNature.addAutotoolsNature((IProject)proj, (IProgressMonitor)monitor);
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)proj);
        IConfiguration[] cfgs = info.getManagedProject().getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            IConfiguration cfg = cfgs[i];
            ICConfigurationDescription cfgd = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)cfg);
            String id = cfgd.getId();
            AutotoolsConfigurationManager.getInstance().getConfiguration(proj, id, true);
            ++i;
        }
        AutotoolsConfigurationManager.getInstance().saveConfigs(proj);
    }
}

