/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import org.eclipse.net4j.util.DoubleBiPredicate;
import org.eclipse.net4j.util.LongBiPredicate;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.factory.SingletonFactory;

@FunctionalInterface
public interface StringTester
extends BiPredicate<String, String> {
    public static final String PRODUCT_GROUP = "org.eclipse.net4j.util.stringTesters";
    public static final StringTester EQ = (s1, s2) -> s1.equals(s2);
    public static final StringTester EQ_CI = EQ.caseInsensitive();
    public static final StringTester EQ_INT = StringTester.asInt((v1, v2) -> v1 == v2);
    public static final StringTester EQ_FLOAT = StringTester.asFloat((v1, v2) -> v1 == v2);
    public static final StringTester NEQ = EQ.negate();
    public static final StringTester NEQ_CI = NEQ.caseInsensitive();
    public static final StringTester NEQ_INT = StringTester.asInt((v1, v2) -> v1 != v2);
    public static final StringTester NEQ_FLOAT = StringTester.asFloat((v1, v2) -> v1 != v2);
    public static final StringTester LT = (s1, s2) -> StringUtil.compare(s1, s2) < 0;
    public static final StringTester LT_CI = LT.caseInsensitive();
    public static final StringTester LT_INT = StringTester.asInt((v1, v2) -> v1 < v2);
    public static final StringTester LT_FLOAT = StringTester.asFloat((v1, v2) -> v1 < v2);
    public static final StringTester LTE = (s1, s2) -> StringUtil.compare(s1, s2) <= 0;
    public static final StringTester LTE_CI = LTE.caseInsensitive();
    public static final StringTester LTE_INT = StringTester.asInt((v1, v2) -> v1 <= v2);
    public static final StringTester LTE_FLOAT = StringTester.asFloat((v1, v2) -> v1 <= v2);
    public static final StringTester GT = (s1, s2) -> StringUtil.compare(s1, s2) > 0;
    public static final StringTester GT_CI = GT.caseInsensitive();
    public static final StringTester GT_INT = StringTester.asInt((v1, v2) -> v1 > v2);
    public static final StringTester GT_FLOAT = StringTester.asFloat((v1, v2) -> v1 > v2);
    public static final StringTester GTE = (s1, s2) -> StringUtil.compare(s1, s2) >= 0;
    public static final StringTester GTE_CI = GTE.caseInsensitive();
    public static final StringTester GTE_INT = StringTester.asInt((v1, v2) -> v1 >= v2);
    public static final StringTester GTE_FLOAT = StringTester.asFloat((v1, v2) -> v1 >= v2);
    public static final StringTester CONTAINS = (s1, s2) -> s1.contains(s2);
    public static final StringTester CONTAINS_CI = CONTAINS.caseInsensitive();
    public static final StringTester REGEX = (s1, s2) -> Pattern.compile(s2).matcher(s1).matches();
    public static final StringTester REGEX_CI = (s1, s2) -> Pattern.compile(s2, 2).matcher(s1).matches();
    public static final StringTester REGEX_FIND = (s1, s2) -> Pattern.compile(s2).matcher(s1).find();
    public static final StringTester REGEX_FIND_CI = (s1, s2) -> Pattern.compile(s2, 2).matcher(s1).find();
    public static final StringTester GLOB = (s1, s2) -> StringUtil.glob(s2, s1);
    public static final StringTester GLOB_CI = GLOB.caseInsensitive();

    @Override
    public boolean test(String var1, String var2);

    default public StringTester negate() {
        return (s1, s2) -> !this.test(s1, s2);
    }

    default public StringTester and(BiPredicate<? super String, ? super String> other) {
        Objects.requireNonNull(other);
        return (s1, s2) -> this.test(s1, s2) && other.test(s1, s2);
    }

    default public StringTester or(BiPredicate<? super String, ? super String> other) {
        Objects.requireNonNull(other);
        return (s1, s2) -> this.test(s1, s2) || other.test(s1, s2);
    }

    default public StringTester safe() {
        return (s1, s2) -> s1 == null || s2 == null ? false : this.test(s1, s2);
    }

    default public StringTester caseInsensitive() {
        return (s1, s2) -> this.test(s1.toLowerCase(), s2.toLowerCase());
    }

    public static StringTester safe(StringTester other) {
        Objects.requireNonNull(other);
        return other.safe();
    }

    public static StringTester caseInsensitive(StringTester other) {
        Objects.requireNonNull(other);
        return other.caseInsensitive();
    }

    public static StringTester asInt(LongBiPredicate other) {
        Objects.requireNonNull(other);
        return (s1, s2) -> {
            long v1 = Long.parseLong(s1);
            long v2 = Long.parseLong(s2);
            return other.test(v1, v2);
        };
    }

    public static StringTester asFloat(DoubleBiPredicate other) {
        Objects.requireNonNull(other);
        return (s1, s2) -> {
            double v1 = Double.parseDouble(s1);
            double v2 = Double.parseDouble(s2);
            return other.test(v1, v2);
        };
    }

    public static final class MetaFactory
    extends org.eclipse.net4j.util.factory.MetaFactory {
        private static final String PG = "org.eclipse.net4j.util.stringTesters";
        private static final IFactory[] CHILDREN = new IFactory[]{new SingletonFactory("org.eclipse.net4j.util.stringTesters", "eq", EQ), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "eq_ci", EQ_CI), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "eq_int", EQ_INT), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "eq_float", EQ_FLOAT), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "neq", NEQ), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "neq_ci", NEQ_CI), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "neq_int", NEQ_INT), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "neq_float", NEQ_FLOAT), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "lt", LT), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "lt_ci", LT_CI), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "lt_int", LT_INT), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "lt_float", LT_FLOAT), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "lte", LTE), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "lte_ci", LTE_CI), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "lte_int", LTE_INT), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "lte_float", LTE_FLOAT), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "gt", GT), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "gt_ci", GT_CI), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "gt_int", GT_INT), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "gt_float", GT_FLOAT), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "gte", GTE), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "gte_ci", GTE_CI), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "gte_int", GTE_INT), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "gte_float", GTE_FLOAT), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "contains", CONTAINS), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "contains_ci", CONTAINS_CI), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "regex", REGEX), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "regex_ci", REGEX_CI), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "regex_find", REGEX_FIND), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "regex_find_ci", REGEX_FIND_CI), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "glob", GLOB), new SingletonFactory("org.eclipse.net4j.util.stringTesters", "glob_ci", GLOB_CI)};

        public MetaFactory() {
            super("org.eclipse.net4j.util.stringTesters");
        }

        @Override
        public IFactory[] create(String description) throws ProductCreationException {
            return CHILDREN;
        }
    }
}

