/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.layout.ordering;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.AbstractViewOrdering;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.ViewOrdering;

public class SimpleCompositeViewOrdering
extends AbstractViewOrdering {
    private List<ViewOrdering> viewOrderings = new LinkedList<ViewOrdering>();

    public void addViewOrdering(ViewOrdering viewOrdering) {
        this.viewOrderings.add(viewOrdering);
    }

    @Override
    protected List<View> sortViews(List<View> views) {
        Iterator<View> iterAllViews = views.iterator();
        HashMap<ViewOrdering, LinkedList<View>> viewOrderingsToViews = new HashMap<ViewOrdering, LinkedList<View>>();
        LinkedList<View> nullViewOrdering = new LinkedList<View>();
        while (iterAllViews.hasNext()) {
            View currentView = iterAllViews.next();
            ViewOrdering viewOrdering = this.getViewOrderingFor(currentView);
            if (viewOrdering == null) {
                nullViewOrdering.add(currentView);
                continue;
            }
            LinkedList<View> currentViews = (LinkedList<View>)viewOrderingsToViews.get(viewOrdering);
            if (currentViews == null) {
                currentViews = new LinkedList<View>();
                viewOrderingsToViews.put(viewOrdering, currentViews);
            }
            currentViews.add(currentView);
        }
        LinkedList<View> sortedViews = new LinkedList<View>();
        ListIterator<ViewOrdering> iterViewOrderings = this.viewOrderings.listIterator();
        while (iterViewOrderings.hasNext()) {
            ViewOrdering currentViewOrdering = (ViewOrdering)iterViewOrderings.next();
            List correspondingViews = (List)viewOrderingsToViews.get(currentViewOrdering);
            if (correspondingViews == null) continue;
            currentViewOrdering.setViews(correspondingViews);
            sortedViews.addAll(currentViewOrdering.getSortedViews());
        }
        sortedViews.addAll(nullViewOrdering);
        return sortedViews;
    }

    @Override
    public boolean isAbleToManageView(View view) {
        return this.getViewOrderingFor(view) != null;
    }

    protected ViewOrdering getViewOrderingFor(View view) {
        ListIterator<ViewOrdering> iterViewOrderings = this.viewOrderings.listIterator();
        while (iterViewOrderings.hasNext()) {
            ViewOrdering currentViewOrdering = (ViewOrdering)iterViewOrderings.next();
            if (!currentViewOrdering.isAbleToManageView(view)) continue;
            return currentViewOrdering;
        }
        return null;
    }
}

