/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.design.editparts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDAdapterFactory;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDModelGroupAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.CenteredConnectionAnchor;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.wst.xsd.ui.internal.design.editparts.ConnectableEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.ModelGroupDefinitionReferenceEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.ReferenceConnection;
import org.eclipse.wst.xsd.ui.internal.design.editparts.TargetConnectionSpacingFigureEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.model.TargetConnectionSpaceFiller;
import org.eclipse.wst.xsd.ui.internal.design.figures.GenericGroupFigure;
import org.eclipse.wst.xsd.ui.internal.design.figures.ModelGroupFigure;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDWildcard;

public class ModelGroupEditPart
extends ConnectableEditPart {
    protected IFigure createFigure() {
        return this.getExtendedFigureFactory().createModelGroupFigure(this.getModel());
    }

    public XSDParticle getXSDParticle() {
        XSDConcreteComponent o = this.getXSDModelGroup().getContainer();
        return o instanceof XSDParticle ? (XSDParticle)o : null;
    }

    public XSDModelGroup getXSDModelGroup() {
        if (this.getModel() instanceof XSDModelGroupAdapter) {
            XSDModelGroupAdapter adapter = (XSDModelGroupAdapter)this.getModel();
            return (XSDModelGroup)adapter.getTarget();
        }
        return null;
    }

    protected void refreshVisuals() {
        boolean isReadOnly = false;
        GenericGroupFigure modelGroupFigure = (GenericGroupFigure)this.getFigure();
        XSDModelGroupAdapter adapter = (XSDModelGroupAdapter)this.getModel();
        isReadOnly = adapter.isReadOnly();
        String nodeName = "";
        switch (this.getXSDModelGroup().getCompositor().getValue()) {
            case 0: {
                Image image = isReadOnly ? ModelGroupFigure.ALL_ICON_DISABLED_IMAGE : ModelGroupFigure.ALL_ICON_IMAGE;
                modelGroupFigure.getIconFigure().image = XSDCommonUIUtils.getUpdatedImage((XSDConcreteComponent)adapter.getTarget(), image, isReadOnly);
                nodeName = "all";
                break;
            }
            case 1: {
                Image image = isReadOnly ? ModelGroupFigure.CHOICE_ICON_DISABLED_IMAGE : ModelGroupFigure.CHOICE_ICON_IMAGE;
                modelGroupFigure.getIconFigure().image = XSDCommonUIUtils.getUpdatedImage((XSDConcreteComponent)adapter.getTarget(), image, isReadOnly);
                nodeName = "choice";
                break;
            }
            case 2: {
                Image image = isReadOnly ? ModelGroupFigure.SEQUENCE_ICON_DISABLED_IMAGE : ModelGroupFigure.SEQUENCE_ICON_IMAGE;
                modelGroupFigure.getIconFigure().image = XSDCommonUIUtils.getUpdatedImage((XSDConcreteComponent)adapter.getTarget(), image, isReadOnly);
                nodeName = "sequence";
            }
        }
        int minOccurs = adapter.getMinOccurs();
        int maxOccurs = adapter.getMaxOccurs();
        String occurenceDescription = "";
        if (minOccurs == -3 && maxOccurs == -3) {
            occurenceDescription = nodeName;
            modelGroupFigure.setText(null);
        } else if (minOccurs == 0 && (maxOccurs == -2 || maxOccurs == 1)) {
            occurenceDescription = String.valueOf(nodeName) + " [0..1]";
            modelGroupFigure.setText("0..1");
        } else if (minOccurs == 1 && maxOccurs == 1 || minOccurs == -2 && maxOccurs == 1 || minOccurs == 1 && maxOccurs == -2) {
            occurenceDescription = String.valueOf(nodeName) + " [1..1]";
            modelGroupFigure.setText("1..1");
        } else if (minOccurs == -2 && maxOccurs == -2) {
            occurenceDescription = nodeName;
            modelGroupFigure.setText(null);
        } else {
            if (maxOccurs == -2) {
                maxOccurs = 1;
            }
            String maxSymbol = maxOccurs == -1 ? "*" : "" + maxOccurs;
            String minSymbol = minOccurs == -2 ? "1" : "" + minOccurs;
            occurenceDescription = String.valueOf(nodeName) + " [" + minSymbol + ".." + maxSymbol + "]";
            modelGroupFigure.setText(String.valueOf(minSymbol) + ".." + maxSymbol);
        }
        modelGroupFigure.getIconFigure().setToolTipText(occurenceDescription);
        modelGroupFigure.getIconFigure().repaint();
        this.refreshConnection();
        List children = this.getChildren();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof BaseEditPart)) continue;
            BaseEditPart base = (BaseEditPart)obj;
            base.refresh();
        }
    }

    protected List getModelChildren() {
        ArrayList<TargetConnectionSpaceFiller> list = new ArrayList<TargetConnectionSpaceFiller>();
        XSDModelGroup xsdModelGroup = this.getXSDModelGroup();
        Iterator i = xsdModelGroup.getContents().iterator();
        while (i.hasNext()) {
            Adapter adapter;
            XSDParticle next = (XSDParticle)i.next();
            if (next.getContent() instanceof XSDElementDeclaration) {
                XSDElementDeclaration elementDeclaration = (XSDElementDeclaration)next.getContent();
                adapter = XSDAdapterFactory.getInstance().adapt((Notifier)elementDeclaration);
                list.add(new TargetConnectionSpaceFiller((XSDBaseAdapter)adapter));
            }
            if (next.getContent() instanceof XSDModelGroupDefinition) {
                XSDModelGroupDefinition def = (XSDModelGroupDefinition)next.getContent();
                adapter = XSDAdapterFactory.getInstance().adapt((Notifier)def);
                list.add((TargetConnectionSpaceFiller)adapter);
                continue;
            }
            if (next.getTerm() instanceof XSDModelGroup) {
                XSDModelGroup modelGroup = (XSDModelGroup)next.getTerm();
                adapter = XSDAdapterFactory.getInstance().adapt((Notifier)modelGroup);
                list.add((TargetConnectionSpaceFiller)adapter);
                continue;
            }
            if (!(next.getTerm() instanceof XSDWildcard)) continue;
            XSDWildcard wildCard = (XSDWildcard)next.getTerm();
            adapter = XSDAdapterFactory.getInstance().adapt((Notifier)wildCard);
            list.add(new TargetConnectionSpaceFiller((XSDBaseAdapter)adapter));
        }
        if (list.size() == 0) {
            list.add(new TargetConnectionSpaceFiller(null));
        }
        return list;
    }

    public ReferenceConnection createConnectionFigure(BaseEditPart child) {
        ReferenceConnection connectionFigure = new ReferenceConnection();
        GenericGroupFigure modelGroupFigure = (GenericGroupFigure)this.getFigure();
        connectionFigure.setSourceAnchor((ConnectionAnchor)new CenteredConnectionAnchor((IFigure)modelGroupFigure.getIconFigure(), 3, 0, 0));
        if (child instanceof ModelGroupEditPart) {
            connectionFigure.setTargetAnchor((ConnectionAnchor)new CenteredConnectionAnchor((IFigure)((ModelGroupEditPart)child).getTargetFigure(), 2, 0, 0));
        } else if (child instanceof TargetConnectionSpacingFigureEditPart) {
            TargetConnectionSpacingFigureEditPart elem = (TargetConnectionSpacingFigureEditPart)child;
            connectionFigure.setTargetAnchor((ConnectionAnchor)new CenteredConnectionAnchor(elem.getFigure(), 2, 0, 1));
        } else if (child instanceof ModelGroupDefinitionReferenceEditPart) {
            ModelGroupDefinitionReferenceEditPart elem = (ModelGroupDefinitionReferenceEditPart)child;
            connectionFigure.setTargetAnchor((ConnectionAnchor)new CenteredConnectionAnchor(elem.getFigure(), 2, 0, 1));
        }
        connectionFigure.setHighlight(false);
        return connectionFigure;
    }

    public String getReaderText() {
        XSDModelGroup xsdModelGroup = this.getXSDModelGroup();
        return xsdModelGroup.getCompositor().getName();
    }
}

