/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.query.IUProfilePropertyQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;

public class RequestFlexer {
    static final String INCLUSION_RULES = "org.eclipse.equinox.p2.internal.inclusion.rules";
    static final String INCLUSION_OPTIONAL = "OPTIONAL";
    static final String INCLUSION_STRICT = "STRICT";
    static final String EXPLANATION_ENABLEMENT = "org.eclipse.equinox.p2.director.explain";
    IPlanner planner;
    private boolean allowInstalledUpdate = false;
    private boolean allowInstalledRemoval = false;
    private boolean allowDifferentVersion = false;
    private boolean allowPartialInstall = false;
    private boolean ensureProductPresence = true;
    private final boolean honorSharedSettings = true;
    private ProvisioningContext provisioningContext;
    Set<IRequirement> requirementsForElementsBeingInstalled = new HashSet<IRequirement>();
    Set<IRequirement> requirementsForElementsAlreadyInstalled = new HashSet<IRequirement>();
    Map<IRequirement, Map<String, String>> propertiesPerRequirement = new HashMap<IRequirement, Map<String, String>>();
    Map<IRequirement, List<String>> removedPropertiesPerRequirement = new HashMap<IRequirement, List<String>>();
    IProfile profile;
    private boolean foundDifferentVersionsForElementsToInstall = false;
    private boolean foundDifferentVersionsForElementsInstalled = false;
    private Set<IInstallableUnit> futureOptionalIUs;

    public RequestFlexer(IPlanner planner) {
        this.planner = planner;
    }

    public void setAllowInstalledElementChange(boolean allow) {
        this.allowInstalledUpdate = allow;
    }

    public void setAllowInstalledElementRemoval(boolean allow) {
        this.allowInstalledRemoval = allow;
    }

    public void setAllowDifferentVersion(boolean allow) {
        this.allowDifferentVersion = allow;
    }

    public void setAllowPartialInstall(boolean allow) {
        this.allowPartialInstall = allow;
    }

    public void setProvisioningContext(ProvisioningContext context) {
        this.provisioningContext = context;
    }

    public void setEnsureProduct(boolean productPresent) {
        this.ensureProductPresence = productPresent;
    }

    public IProfileChangeRequest getChangeRequest(IProfileChangeRequest request, IProfile prof, IProgressMonitor monitor) {
        this.profile = prof;
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IProfileChangeRequest loosenedRequest = this.computeLooseRequest(request, (IProgressMonitor)sub.newChild(1));
        if (this.canShortCircuit(request)) {
            return null;
        }
        IProvisioningPlan intermediaryPlan = this.resolve(loosenedRequest, (IProgressMonitor)sub.newChild(1));
        if (!intermediaryPlan.getStatus().isOK()) {
            return null;
        }
        if (intermediaryPlan.getAdditions().query(QueryUtil.ALL_UNITS, (IProgressMonitor)new NullProgressMonitor()).isEmpty() && intermediaryPlan.getRemovals().query(QueryUtil.ALL_UNITS, (IProgressMonitor)new NullProgressMonitor()).isEmpty()) {
            return null;
        }
        if (!this.productContainmentOK(intermediaryPlan)) {
            return null;
        }
        IProfileChangeRequest effectiveRequest = this.computeEffectiveChangeRequest(intermediaryPlan, loosenedRequest, request);
        if (this.isRequestUseless(effectiveRequest)) {
            return null;
        }
        return effectiveRequest;
    }

    private boolean isRequestUseless(IProfileChangeRequest effectiveRequest) {
        if (effectiveRequest.getAdditions().isEmpty() && effectiveRequest.getRemovals().isEmpty()) {
            return true;
        }
        return effectiveRequest.getRemovals().containsAll(effectiveRequest.getAdditions());
    }

    private boolean canShortCircuit(IProfileChangeRequest originalRequest) {
        if (this.allowPartialInstall && !this.allowInstalledUpdate && !this.allowDifferentVersion && !this.allowInstalledRemoval && originalRequest.getAdditions().size() == 1) {
            return true;
        }
        if (!(!this.allowDifferentVersion || this.allowPartialInstall || this.allowInstalledRemoval || this.allowInstalledUpdate || this.foundDifferentVersionsForElementsToInstall)) {
            return true;
        }
        if (!(!this.allowInstalledUpdate || this.allowDifferentVersion || this.allowPartialInstall || this.allowInstalledRemoval || this.foundDifferentVersionsForElementsInstalled)) {
            return true;
        }
        return !this.allowPartialInstall && !this.allowInstalledUpdate && !this.allowDifferentVersion && !this.allowInstalledRemoval;
    }

    private IProfileChangeRequest computeEffectiveChangeRequest(IProvisioningPlan intermediaryPlan, IProfileChangeRequest loosenedRequest, IProfileChangeRequest originalRequest) {
        IQueryResult matches;
        IQuery query;
        IProfileChangeRequest finalChangeRequest = this.planner.createChangeRequest(this.profile);
        HashSet<IInstallableUnit> iusToAdd = new HashSet<IInstallableUnit>();
        HashSet iusToRemove = new HashSet();
        for (IRequirement beingInstalled : this.requirementsForElementsBeingInstalled) {
            query = QueryUtil.createMatchQuery((IExpression)beingInstalled.getMatches(), (Object[])new Object[0]);
            matches = intermediaryPlan.getFutureState().query(QueryUtil.createLatestQuery((IQuery)query), null);
            IInstallableUnit replacementIU = null;
            if (matches.isEmpty()) continue;
            replacementIU = (IInstallableUnit)matches.iterator().next();
            iusToAdd.add(replacementIU);
            this.adaptIUPropertiesToNewIU(beingInstalled, replacementIU, finalChangeRequest);
        }
        for (IRequirement alreadyInstalled : this.requirementsForElementsAlreadyInstalled) {
            IQueryResult iuAlreadyInstalled;
            query = QueryUtil.createMatchQuery((IExpression)alreadyInstalled.getMatches(), (Object[])new Object[0]);
            matches = intermediaryPlan.getFutureState().query(QueryUtil.createLatestQuery((IQuery)query), null);
            IInstallableUnit potentialRootChange = null;
            if (!matches.isEmpty()) {
                potentialRootChange = (IInstallableUnit)matches.iterator().next();
            }
            if (!(iuAlreadyInstalled = this.profile.available(query, (IProgressMonitor)new NullProgressMonitor())).isEmpty() && potentialRootChange != null && iuAlreadyInstalled.toUnmodifiableSet().contains(potentialRootChange)) continue;
            iusToRemove.addAll(iuAlreadyInstalled.toUnmodifiableSet());
            if (potentialRootChange == null || iusToAdd.contains(potentialRootChange)) continue;
            iusToAdd.add(potentialRootChange);
            this.adaptIUPropertiesToNewIU(alreadyInstalled, potentialRootChange, finalChangeRequest);
        }
        iusToRemove.addAll(originalRequest.getRemovals());
        HashSet commons = new HashSet(iusToAdd);
        if (commons.retainAll(iusToRemove)) {
            iusToAdd.removeAll(commons);
            iusToRemove.removeAll(commons);
        }
        finalChangeRequest.addAll(iusToAdd);
        finalChangeRequest.removeAll(iusToRemove);
        if (originalRequest.getExtraRequirements() != null) {
            finalChangeRequest.addExtraRequirements(originalRequest.getExtraRequirements());
        }
        return finalChangeRequest;
    }

    private void adaptIUPropertiesToNewIU(IRequirement beingInstalled, IInstallableUnit newIU, IProfileChangeRequest finalChangeRequest) {
        List<String> removedProperties;
        Map<String, String> associatedProperties = this.propertiesPerRequirement.get(beingInstalled);
        if (associatedProperties != null) {
            Set<Map.Entry<String, String>> entries = associatedProperties.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                finalChangeRequest.setInstallableUnitProfileProperty(newIU, entry.getKey(), entry.getValue());
            }
        }
        if ((removedProperties = this.removedPropertiesPerRequirement.get(beingInstalled)) != null) {
            for (String toRemove : removedProperties) {
                finalChangeRequest.removeInstallableUnitProfileProperty(newIU, toRemove);
            }
        }
    }

    private IProfileChangeRequest computeLooseRequest(IProfileChangeRequest originalRequest, IProgressMonitor monitor) {
        IProfileChangeRequest loosenedRequest = this.planner.createChangeRequest(this.profile);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        this.loosenUpOriginalRequest(loosenedRequest, originalRequest, (IProgressMonitor)sub.newChild(1));
        this.loosenUpInstalledSoftware(loosenedRequest, originalRequest, (IProgressMonitor)sub.newChild(1));
        return loosenedRequest;
    }

    private boolean removalRequested(IInstallableUnit removalRequested, IProfileChangeRequest request) {
        return request.getRemovals().contains(removalRequested);
    }

    private IProvisioningPlan resolve(IProfileChangeRequest temporaryRequest, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        String explainPropertyBackup = null;
        try {
            temporaryRequest.setProfileProperty("_internal_user_defined_", "true");
            if (this.provisioningContext != null) {
                explainPropertyBackup = this.provisioningContext.getProperty(EXPLANATION_ENABLEMENT);
                this.provisioningContext.setProperty(EXPLANATION_ENABLEMENT, Boolean.FALSE.toString());
            }
            IProvisioningPlan iProvisioningPlan = this.planner.getProvisioningPlan(temporaryRequest, this.provisioningContext, (IProgressMonitor)subMonitor.split(1));
            return iProvisioningPlan;
        }
        finally {
            if (this.provisioningContext != null) {
                if (explainPropertyBackup == null) {
                    this.provisioningContext.getProperties().remove(EXPLANATION_ENABLEMENT);
                } else {
                    this.provisioningContext.setProperty(EXPLANATION_ENABLEMENT, explainPropertyBackup);
                }
            }
        }
    }

    private void loosenUpOriginalRequest(IProfileChangeRequest newRequest, IProfileChangeRequest originalRequest, IProgressMonitor monitor) {
        Collection requestedAdditions = originalRequest.getAdditions();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)requestedAdditions.size());
        for (IInstallableUnit addedIU : requestedAdditions) {
            SubMonitor iterationMonitor = subMonitor.split(1);
            Collection<Object> potentialUpdates = this.allowDifferentVersion ? this.findAllVersionsAvailable(addedIU, (IProgressMonitor)iterationMonitor) : new ArrayList();
            this.foundDifferentVersionsForElementsToInstall = this.foundDifferentVersionsForElementsToInstall || potentialUpdates.size() != 0;
            potentialUpdates.add(addedIU);
            ArrayList<IRequirement> newRequirement = new ArrayList<IRequirement>(1);
            IRequirement req = this.createORRequirement(potentialUpdates, this.allowPartialInstall || this.isRequestedInstallationOptional(addedIU, originalRequest));
            newRequirement.add(req);
            newRequest.addExtraRequirements(newRequirement);
            this.requirementsForElementsBeingInstalled.addAll(newRequirement);
            this.rememberIUProfileProperties(addedIU, req, originalRequest, false);
        }
        newRequest.removeAll(originalRequest.getRemovals());
        if (originalRequest.getExtraRequirements() != null) {
            newRequest.addExtraRequirements(originalRequest.getExtraRequirements());
        }
    }

    private void rememberIUProfileProperties(IInstallableUnit iu, IRequirement req, IProfileChangeRequest originalRequest, boolean includeProfile) {
        Map propertiesInRequest;
        HashMap allProperties = new HashMap();
        if (includeProfile) {
            HashMap tmp = new HashMap(this.profile.getInstallableUnitProperties(iu));
            List propertiesToRemove = (List)((ProfileChangeRequest)originalRequest).getInstallableUnitProfilePropertiesToRemove().get(iu);
            if (propertiesToRemove != null) {
                for (String toRemove : propertiesToRemove) {
                    tmp.remove(toRemove);
                }
            }
            allProperties.putAll(tmp);
        }
        if ((propertiesInRequest = (Map)((ProfileChangeRequest)originalRequest).getInstallableUnitProfilePropertiesToAdd().get(iu)) != null) {
            allProperties.putAll(propertiesInRequest);
        }
        this.propertiesPerRequirement.put(req, allProperties);
        List removalInRequest = (List)((ProfileChangeRequest)originalRequest).getInstallableUnitProfilePropertiesToRemove().get(iu);
        if (removalInRequest != null) {
            this.removedPropertiesPerRequirement.put(req, removalInRequest);
        }
    }

    private boolean isRequestedInstallationOptional(IInstallableUnit iu, IProfileChangeRequest originalRequest) {
        Map match = (Map)((ProfileChangeRequest)originalRequest).getInstallableUnitProfilePropertiesToAdd().get(iu);
        if (match == null) {
            return false;
        }
        return INCLUSION_OPTIONAL.equals(match.get(INCLUSION_RULES));
    }

    private Collection<IInstallableUnit> findAllVersionsAvailable(IInstallableUnit iu, IProgressMonitor monitor) {
        HashSet<IInstallableUnit> allVersions = new HashSet<IInstallableUnit>();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        allVersions.addAll(this.findIUsWithSameId(iu, (IProgressMonitor)sub.newChild(1)));
        allVersions.addAll(this.findUpdates(iu, (IProgressMonitor)sub.newChild(1)));
        return allVersions;
    }

    private Collection<IInstallableUnit> findIUsWithSameId(IInstallableUnit iu, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IQueryable metadata = this.provisioningContext.getMetadata((IProgressMonitor)sub.newChild(1));
        return metadata.query(QueryUtil.createIUQuery((String)iu.getId()), (IProgressMonitor)sub.newChild(1)).toUnmodifiableSet();
    }

    private Collection<IInstallableUnit> findUpdates(IInstallableUnit iu, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        HashSet<IInstallableUnit> availableUpdates = new HashSet<IInstallableUnit>();
        IQueryResult updatesAvailable = this.planner.updatesFor(iu, this.provisioningContext, (IProgressMonitor)subMonitor.split(1));
        for (IInstallableUnit unit : updatesAvailable) {
            availableUpdates.add(unit);
        }
        return availableUpdates;
    }

    private IRequirement createORRequirement(Collection<IInstallableUnit> findUpdates, boolean optional) {
        StringBuilder expression = new StringBuilder();
        Object[] expressionParameters = new Object[findUpdates.size() * 2];
        int count = 0;
        for (IInstallableUnit iu : findUpdates) {
            expression.append("(id == $").append(count * 2).append(" && version == $").append(count * 2 + 1).append(')');
            if (findUpdates.size() > 1 && count < findUpdates.size() - 1) {
                expression.append(" || ");
            }
            expressionParameters[count * 2] = iu.getId();
            expressionParameters[count * 2 + 1] = iu.getVersion();
            ++count;
        }
        IMatchExpression iuMatcher = ExpressionUtil.getFactory().matchExpression(ExpressionUtil.parse((String)expression.toString()), expressionParameters);
        return MetadataFactory.createRequirement((IMatchExpression)iuMatcher, null, (int)(optional ? 0 : 1), (int)1, (boolean)true);
    }

    private IProfileChangeRequest loosenUpInstalledSoftware(IProfileChangeRequest request, IProfileChangeRequest originalRequest, IProgressMonitor monitor) {
        if (!this.allowInstalledRemoval && !this.allowInstalledUpdate) {
            return request;
        }
        Set<IInstallableUnit> allRoots = this.getRoots();
        for (IInstallableUnit existingIU : allRoots) {
            Collection<Object> potentialUpdates = this.allowInstalledUpdate ? this.findUpdates(existingIU, monitor) : new HashSet();
            this.foundDifferentVersionsForElementsInstalled = this.foundDifferentVersionsForElementsInstalled || potentialUpdates.size() != 0;
            potentialUpdates.add(existingIU);
            ArrayList<IRequirement> newRequirement = new ArrayList<IRequirement>(1);
            IRequirement req = this.createORRequirement(potentialUpdates, this.allowInstalledRemoval || this.removalRequested(existingIU, originalRequest) || this.isOptionallyInstalled(existingIU, originalRequest));
            newRequirement.add(req);
            request.addExtraRequirements(newRequirement);
            this.requirementsForElementsAlreadyInstalled.addAll(newRequirement);
            request.remove(existingIU);
            this.rememberIUProfileProperties(existingIU, req, originalRequest, true);
        }
        return request;
    }

    private Set<IInstallableUnit> getRoots() {
        Set allRoots = this.profile.query((IQuery)new IUProfilePropertyQuery(INCLUSION_RULES, "*"), null).toSet();
        IQueryResult baseRoots = this.profile.query((IQuery)new IUProfilePropertyQuery("org.eclipse.equinox.p2.base", Boolean.TRUE.toString()), null);
        allRoots.removeAll(baseRoots.toUnmodifiableSet());
        return allRoots;
    }

    private boolean isOptionallyInstalled(IInstallableUnit existingIU, IProfileChangeRequest request) {
        return this.computeFutureStateOfInclusion((ProfileChangeRequest)request).contains(existingIU);
    }

    private Set<IInstallableUnit> computeFutureStateOfInclusion(ProfileChangeRequest profileChangeRequest) {
        if (this.futureOptionalIUs != null) {
            return this.futureOptionalIUs;
        }
        this.futureOptionalIUs = profileChangeRequest.getProfile().query((IQuery)new IUProfilePropertyQuery(INCLUSION_RULES, INCLUSION_OPTIONAL), null).toSet();
        Set propertiesBeingRemoved = profileChangeRequest.getInstallableUnitProfilePropertiesToRemove().entrySet();
        for (Map.Entry propertyRemoved : propertiesBeingRemoved) {
            if (!((List)propertyRemoved.getValue()).contains(INCLUSION_RULES)) continue;
            this.futureOptionalIUs.remove(propertyRemoved.getKey());
        }
        Set propertiesBeingAdded = profileChangeRequest.getInstallableUnitProfilePropertiesToAdd().entrySet();
        for (Map.Entry propertyBeingAdded : propertiesBeingAdded) {
            String inclusionRule = (String)((Map)propertyBeingAdded.getValue()).get(INCLUSION_RULES);
            if (inclusionRule == null) continue;
            if (INCLUSION_STRICT.equals(inclusionRule)) {
                this.futureOptionalIUs.remove(propertyBeingAdded.getKey());
            }
            if (!INCLUSION_OPTIONAL.equals(inclusionRule)) continue;
            this.futureOptionalIUs.add((IInstallableUnit)propertyBeingAdded.getKey());
        }
        return this.futureOptionalIUs;
    }

    private boolean productContainmentOK(IProvisioningPlan intermediaryPlan) {
        if (!this.ensureProductPresence) {
            return true;
        }
        if (!this.hasProduct()) {
            return true;
        }
        if (!intermediaryPlan.getFutureState().query(QueryUtil.createIUProductQuery(), (IProgressMonitor)new NullProgressMonitor()).isEmpty()) {
            return true;
        }
        return !intermediaryPlan.getFutureState().query(QueryUtil.createIUPropertyQuery((String)"lineUp", (String)"true"), (IProgressMonitor)new NullProgressMonitor()).isEmpty();
    }

    private boolean hasProduct() {
        if (!this.profile.available(QueryUtil.createIUProductQuery(), (IProgressMonitor)new NullProgressMonitor()).isEmpty()) {
            return true;
        }
        return !this.profile.available(QueryUtil.createIUPropertyQuery((String)"lineUp", (String)"true"), (IProgressMonitor)new NullProgressMonitor()).isEmpty();
    }
}

